//#include "global.h"

#include <arpschuino.h>
//#include <arpschuino32_core.h>
#include <vector>
#include "Port.h"
#include "I2C_port.h"
#include <ArtnetWiFi.h>
using std::vector;
#include "signal.h"
// #ifdef ARPSCHUINO32 
//     #include <esp_dmx.h>  //  https://github.com/someweisguy/esp_dmx
// #endif

#ifdef PIXEL
  #include "pixel.h"
  // extern Adafruit_NeoPixel statusLED;
  // extern uint8_t status;
  extern 
  Pixel statusLED;
#endif

#ifdef WILULU32 
  extern Port portW;
#endif
extern Port portA;  //objets port
#ifdef ARPSCHUINO32 
  extern Port portB;
#endif
extern vector<Device*>I2C_port ;

int address;
#ifdef ARPSCHUINO32 
  int nbre_circuits = portA.getNbDmxChannels()+portB.getNbDmxChannels();///////////INUTILE ??
#endif
#ifdef WILULU32
  int nbre_circuits = portW.getNbDmxChannels()+portA.getNbDmxChannels();///////////INUTILE ??
#endif
// Artnet stuff
ArtnetWiFi artnet;
uint8_t universe;  // 0 - 15

extern bool connected_to_my_network;
extern uint8_t signal_mode;

#ifdef ARPSCHUINO32 
  DMX_port DMX1;
#endif


// void OnDataRecv(const uint8_t * mac, const uint8_t *incomingData, int len);

// typedef struct struct_message {
//   char a[32];
//   int b;
//   float c;
//   bool d;
// } struct_message;
// struct_message myData;

/////////////////// Artnet fonctions //////////////////////////////////////
void Artnet_init()
{
    artnet.begin();
    artnet.subscribe(universe, callback);
    #ifdef ARPSCHUINO32
      artnet.shortname("arpschuino32");
    #endif
    #ifdef WILULU32
      artnet.shortname("wilulu32");
    #endif    
    artnet.longname(WiFi.getHostname());
    String s1="addr:",s2=String(address);
    String s3=",univ:",s4=String(universe);
    String s5=",mode:",s6;//=signal_mode;
    #ifdef ARPSCHUINO32
      switch(signal_mode){//à optimiser avec init_preferences();
        case 0:
          s6="DMX or Artnet in";
          break;
        case 1:
          s6="DMX in";
          break;
        case 2:
          s6="Artnet in";
          break;         
        case 3:
          s6="DMX in Artnet out";
          break;
        case 4:
          s6="Artnet in DMX out";
          break;                
      }
    #endif
    #ifdef WILULU32
      s6="Artnet in";
    #endif
    String s7=",A:",s8=portA.writeMode(); 
    #ifdef ARPSCHUINO32
      String s9=",B:",s10=portB.writeMode();
      
      String report=s1+s2+s3+s4+s5+s6+s7+s8+s9+s10;//+s11;
    #endif
    #ifdef WILULU32
      String report=s1+s2+s3+s4+s5+s6+s7+s8;
    #endif
    artnet.nodereport(report);
    
    Serial.println("artnet ready");  
}

void callback(const uint8_t* data, const uint16_t size) 
{
  send_data_to_ports(data, address-1);
  #ifdef PIXEL
    //if(!digitalRead(Arp2))////////////////////////////////special Eli !!
      statusLED.toggle_pix_led(BLUE);
  #endif   
  #ifdef ARPSCHUINO32 
    if(signal_mode==4)
    {
      memcpy((void *)&DMX1._DMXdata[1], (void *)data, 512);
    }
  #endif  
}////////////////////////////////////////////////////////////////////////////
#ifdef ARPSCHUINO32
DMX_port::DMX_port() : _timer(0), _packetCounter(44), _dmxPort (1), _TX(ArpDMX_TX), _RX(ArpDMX_RX), _control(ArpDMXControl)
{
           
}

// DMX_port::DMX_port(dmx_port_t dmxPort) : _dmxPort (dmxPort), _timer(0), _packetCounter(44)
// {

// }
//dmx_port_t dmx_num=1, int tx_io_num=ArpDMX_TX, int rx_io_num=ArpDMX_RX, int rts_io_num=ArpDMXControl

void DMX_port::set_pin(dmx_port_t dmx_num, int tx_io_num, int rx_io_num, int rts_io_num)
{
  _dmxPort=dmx_num;
  _TX=tx_io_num;
  _RX=rx_io_num;
  _control=rts_io_num;
}


void DMX_port::DMX_init()
{
    //_dmxPort=dmx_num;
    dmx_config_t dmxConfig = DMX_DEFAULT_CONFIG;
    dmx_param_config(_dmxPort, &dmxConfig);
    dmx_set_pin(_dmxPort, ArpDMX_TX, ArpDMX_RX, ArpDMXControl);
    int interruptPriority = 1;
    int queueSize;
    if(signal_mode==4)  //dmx out
    {
      queueSize = 0;
      dmx_driver_install(_dmxPort, DMX_MAX_PACKET_SIZE, queueSize, NULL,interruptPriority);
      dmx_set_mode(_dmxPort, DMX_MODE_WRITE);
      _DMXdata[0] = 0;
    }
    else             //dmx in
    {
      queueSize = 1;
      dmx_driver_install(_dmxPort, DMX_MAX_PACKET_SIZE, queueSize, &_queue, interruptPriority);
    }
    Serial.println("DMX ready");
}

bool DMX_port::receive_DMX()
{
  static uint32_t last_receive;
  dmx_event_t packet;
  if (xQueueReceive(_queue, &packet, 0)) 
  {
    if (packet.status == DMX_OK) 
    {
      dmx_read_packet(_dmxPort, _DMXdata, packet.size);
      send_data_to_ports(DMX1._DMXdata, address); 
      last_receive = millis();
      return true; 
    }
 // else : Uh-oh! Something went wrong receiving DMX.
    Serial.println("DMX error!");

  } 
  if(millis() - last_receive > 100)
  {
    return false;
  }
  else return true;   
}///////////////////////////////////////////////////////////////////////////

uint8_t DMX_port::get_DMXdata()
{
  return *_DMXdata;
}
#endif

void signal_action()
{
  //Serial.println("signal action");
  switch(signal_mode)
  {
  #ifdef ARPSCHUINO32
    case 0: {  //DMX or Artnet in
      for(;;)/* loop forever */
      {
        if(not (DMX1.receive_DMX()))
        { 
          if(connected_to_my_network)
          {
            artnet.parse();
          }
        }
        vTaskDelay(25); 
      }          
      break;
    } 
    case 1: {  //DMX in

      for(;;)
      {
        DMX1.receive_DMX();
        vTaskDelay(25); 
      }                 
      break;
    }
  #endif
    case 2: {  //Artnet in
      for(;;)
      {
        if(connected_to_my_network)
        {
          artnet.parse();
        }
        vTaskDelay(25); 
      }          
      break;
    }
  #ifdef ARPSCHUINO32       
    case 3: {  //DMX in Artnet out
      for(;;)
      {      
      if(DMX1.receive_DMX())
        { 
          //mem
          artnet.streaming_data(&DMX1._DMXdata[1], 512);//copy DMX to Artnet
          artnet.streaming("255.255.255.255", universe);  // automatically send set data in 40fps
        } 
        vTaskDelay(25);
      }
                       
      break;
    }
    case 4: {  //Artnet in DMX out
      for(;;)
      {      
        if(connected_to_my_network)
        {
          artnet.parse();
          dmx_write_packet(1, DMX1._DMXdata, DMX_MAX_PACKET_SIZE);//(dmxPort, _DMXdata, DMX_MAX_PACKET_SIZE);
          dmx_send_packet(1, DMX_MAX_PACKET_SIZE);//(dmxPort, DMX_MAX_PACKET_SIZE);
        }
        vTaskDelay(25);
      }          
      break;
    }
  #endif
    case 5: { //ESP NOW IN
      //WiFi.mode(WIFI_AP_STA);///////////////////////test///////////////////////////
      // if (esp_now_init() != ESP_OK) {
      //   Serial.println("Error initializing ESP-NOW");
      //   return;
      // }
      // Serial.print(F("Reciever initialized : "));
      // Serial.println(WiFi.macAddress());
      // // Define receive function
      // esp_now_register_recv_cb(OnDataRecv);

      // for(;;)
      // {      
      //   // if(connected_to_my_network)
      //   // {
      //   //   artnet.parse();
      //   //   dmx_write_packet(1, DMX1._DMXdata, DMX_MAX_PACKET_SIZE);//(dmxPort, _DMXdata, DMX_MAX_PACKET_SIZE);
      //   //   dmx_send_packet(1, DMX_MAX_PACKET_SIZE);//(dmxPort, DMX_MAX_PACKET_SIZE);
      //   // }
      //   vTaskDelay(25);
      // }          
      break;
    }
    default : {
      Serial.println("Wrong mode!!");
    }
  }

  // #ifdef WILULU32
  //     for(;;)
  //     {
  //       if(connected_to_my_network)
  //       {
  //         artnet.parse();
  //       }
  //       vTaskDelay(25); 
  //     } 
  // #endif        

}


void send_data_to_ports(const uint8_t* _data, uint16_t start)
{
  #ifndef PIXEL
    #ifdef ARPSCHUINO32
      Arp_led_temoin (Arp_LED_BUILTIN);
    #endif
    #ifdef WILULU32
      Arp_led_temoin (LED_BUILTIN_CHANNEL, led_builtin_level);
    #endif
  #endif
  vector<uint8_t> DMX_slice{};
  uint16_t end;
  
  ///send_slice_to(portW);

  #ifdef WILULU32
    DMX_slice.clear();/////////////////////utile ???///////////
     
    end=start+portW.getNbDmxChannels();
    for (int i=start; i < end; ++i) 
    {
      if(i>=0 && i<=512)
      {
        DMX_slice.push_back(_data[i]);
      }      
      else DMX_slice.push_back(0);
    }
    portW.action(DMX_slice);  
    start=end;
  #endif

  DMX_slice.clear();/////////////////////utile ???///////////
  end=start+portA.getNbDmxChannels();
  for (int i=start; i < end; ++i) 
  {
    if(i>=0 && i<512)
    {
      DMX_slice.push_back(_data[i]);
    }
    else DMX_slice.push_back(0);
  }
  portA.action(DMX_slice);
  
  #ifdef ARPSCHUINO32
    DMX_slice.clear();/////////////////////utile ???///////////
    start=end; 
    end=start+portB.getNbDmxChannels();
    for (int i=start; i < end; ++i) 
    {
      if(i>=0 && i<=512)
      {
        DMX_slice.push_back(_data[i]);
      }      
      else DMX_slice.push_back(0);
    }
    portB.action(DMX_slice);  
  #endif

  for(uint8_t i=0;i<Device::get_nb_devices();i++)
  {
    DMX_slice.clear();/////////////////////utile ???///////////
    start = end;
    end = start + I2C_port[i]->getNbDmxChannels();
    for (int i=start; i < end; ++i) 
    {
      if(i>=0 && i<512)
      {
        DMX_slice.push_back(_data[i]);
      }      
      else DMX_slice.push_back(0);  
    }
    I2C_port[i]->action(DMX_slice);
  }
}



// void send_slice_to(Port port)
// {
//   DMX_slice.clear();
//   start=end; 
//   end=start+portB.getNbDmxChannels();
//   for (int i=start; i < end; ++i) 
//   {
//     if(i>=0 && i<=512)
//     {
//       DMX_slice.push_back(_data[i]);
//     }      
//     else DMX_slice.push_back(0);
//   }
//   portB.action(DMX_slice); 
// }

// callback when data is received
// void OnDataRecv(const uint8_t * mac, const uint8_t *incomingData, int len) {
//   memcpy(&myData, incomingData, sizeof(myData));
//   Serial.print("Bytes received: ");
//   Serial.println(len);
//   Serial.print("Char: ");
//   Serial.println(myData.a);
//   Serial.print("Int: ");
//   Serial.println(myData.b);
//   Serial.print("Float: ");
//   Serial.println(myData.c);
//   Serial.print("Bool: ");
//   Serial.println(myData.d);
//   Serial.println();
// }