#include "pixel.h"

// uint8_t status=NOT_CONNECTED;
// Adafruit_NeoPixel statusLED(LED_COUNT, Arp_LED_BUILTIN,NEO_GRB + NEO_KHZ800);

#ifdef PIXEL
  Pixel statusLED;
#endif



Pixel::Pixel(): my_pix(LED_COUNT, Arp_LED_BUILTIN,NEO_GRB + NEO_KHZ800)
{

}

void Pixel::begin()
{
    //Adafruit_NeoPixel my_pix = Adafruit_NeoPixel(LED_COUNT, Arp_LED_BUILTIN,NEO_GRB + NEO_KHZ800);
    my_pix.begin();
    my_pix.clear();
    my_pix.setPixelColor(0, my_pix.Color(led_builtin_level, 0, 0));//my_pix.Color(255, 0, 0));
    my_pix.show();
}

void Pixel::setPxCol(uint8_t color, uint8_t pos)
{
    switch( color)
    {
        case RED :{
            my_pix.setPixelColor(pos, my_pix.Color(led_builtin_level, 0, 0));
            break;
        }        
        case  GREEN  :{
            my_pix.setPixelColor(pos, my_pix.Color( 0,led_builtin_level, 0));
            break;
        }
        case BLUE  :{
            my_pix.setPixelColor(pos, my_pix.Color(0, 0, led_builtin_level));
            break;
        }    
        case MAGENTA :{
            my_pix.setPixelColor(pos, my_pix.Color(led_builtin_level, 0, led_builtin_level));
            break;
        }
        case YELLOW  :{
            my_pix.setPixelColor(pos, my_pix.Color(led_builtin_level, led_builtin_level/2, 0));
            break;
        }        
        case  ORANGE  :{
            my_pix.setPixelColor(pos, my_pix.Color(led_builtin_level, led_builtin_level/8, 0));
            break;
        }
        case CYAN  :{
            my_pix.setPixelColor(pos, my_pix.Color(0, led_builtin_level, led_builtin_level));
            break;
        }    
        case PINK  :{
            my_pix.setPixelColor(pos, my_pix.Color(led_builtin_level, led_builtin_level/8, led_builtin_level/2));
            break;
        }
        case WHITE   :{
            my_pix.setPixelColor(pos, my_pix.Color(led_builtin_level, led_builtin_level, led_builtin_level));
            break;
        }    
        case BLACK  :{
            my_pix.setPixelColor(pos, 0);
            break;
        }
    }
    my_pix.show();
}

/* uint32_t Pixel::refresh_statusLED()
{
    uint8_t color;
    switch(_status)
    {
        case LED_OFF :{
            my_pix.setPixelColor(0, BLACK);
            break;
        }        
        case NOT_CONNECTED :{
            my_pix.setPixelColor(0, RED);
            break;
        }
        case STA :{
            my_pix.setPixelColor(0,BLUE);
            break;
        }    
        case AP :{
            my_pix.setPixelColor(0, ORANGE);
            break;
        }
    }
    my_pix.show();
    return my_pix.getPixelColor(0);
}

uint32_t Pixel::set_statusLED(uint8_t status)
{
    _status=status;
    return refresh_statusLED() ;
    // my_pix.setPixelColor(0, BLUE);//my_pix.Color(255, 0, 0));
    // my_pix.show();
    return my_pix.getPixelColor(0);
} */

void Pixel::toggle_pix_led(uint8_t color, uint8_t pos)
{
    _LEDstate = !_LEDstate;
    if(_LEDstate == HIGH)
    {
        setPxCol(BLACK, pos);
    }    
    else
    {
        setPxCol(color, pos);
    }    
}

/* void Pixel::print_colors()
{
    Serial.println();
    Serial.print("RED = ");Serial.println(RED);
    Serial.print("GREEN = ");Serial.println(GREEN);
    Serial.print("BLUE = ");Serial.println(BLUE);
    Serial.print("MAGENTA = ");Serial.println(MAGENTA);
        Serial.print("YELLOW = ");Serial.println(YELLOW);
    Serial.print("ORANGE = ");Serial.println(ORANGE);
        Serial.print("CYAN = ");Serial.println(CYAN);
    Serial.print("PINK = ");Serial.println(PINK);
        Serial.print("WHITE = ");Serial.println(WHITE);
    Serial.print("BLACK = ");Serial.println(my_pix.Color(0, 0, 0)); 
} */