//#include "global.h"

#include <arpschuino.h>
#include <vector>
#include <ArtnetWiFi.h>
#include <Preferences.h>

#include "global.h"
#include "_wifi.h"
#include "arp_server.h"
#include "Port.h"
#include "I2C_port.h"
#include "signal.h"


using std::vector;

//#define BLINK_DEBUG

#ifdef PIXEL
  #include "pixel.h"
  extern Pixel statusLED;
#endif

#ifdef WILULU32
  uint8_t led_builtin_level=50;
  extern Port portW;
#endif
extern Port portA;  //objets port
#ifdef ARPSCHUINO32
  extern Port portB;
  extern DMX_port DMX1;
#endif  
extern vector<Device*>I2C_port ;
extern Preferences preferences;
//

uint8_t signal_mode = 0;//0=DMX or Artnet in; 1=DMX IN 2=Artnet IN 3=DMX in Artnet out; 4= Artnet in DMX out

bool connected_to_my_network=false;;
bool checkupdateFlag=false;
//String new_version;
//extern String update_status;

//Tasks declarations ///
void signal_reception( void * parameter );
void periodic_check( void * parameter );
#ifdef BLINK_DEBUG//////////vars to blink without delay (debug):///////////////////
  void blink_debug( void * parameter );
////////////////////////////////////////////////////////////
  const int blue_led = 2;
  const int green_led = 0;
  // unsigned long previousMillisB = 0;        // will store last time LED was updated
  // const long interval = 1000;           // interval at which to blink (milliseconds)
  int ledState = LOW;             // ledState used to set the LED 
#endif////////////////////////////////////////////////////////////////////////////////

void setup() //running on core 1
{
  //----------------------------------------------------Serial
  Serial.begin(115200);
  Serial.println();
  Serial.println("Version 1.3.0.2(double fianchetto, hotfix)");
  //----------------------------------------------------SPIFFS
  init_SPIFFS();                  //load filesystem
  //----------------------------------------------------arpschuino
  int arpdress = Arp_read_arpdress_board(Arp_SDA,Arp_SCL); //read arpdress board
  if(arpdress>0 && arpdress<513)            //if address is valid
  {
    preferences.begin("wifi_datas", false);
    record("DMX_address", arpdress);
    Serial.println("Get address from arpdress board.");
  }
  else if(arpdress<1000)    //Arp_read_arpdress_board() return 1000 if no arpdress board
  {
    Serial.println("Invalid address from arpdress board, keep previous address.");
  }
  //----------------------------------------------------Preferences
  init_preferences();   //load values stored in EEPROM
  //----------------------------------------------------WIFI
  //connected_to_my_network = start_w_connection();//true if connection is succesfull
    //----------------------------------------------------Voyant
  if(preferences.getBool("LED_builtin", true))
  {
    #ifdef PIXEL
      statusLED.begin();//delay(20000);////////////////////////////////////////////////////////////////////////////////////
    #else    
      pinMode(Arp_LED_BUILTIN,OUTPUT); //green LED 
      #ifdef WILULU32
        ledcSetup(LED_BUILTIN_CHANNEL, 1000, 8); // configure LED PWM functionalitites
        ledcAttachPin(Arp_LED_BUILTIN, 15);     // attach the channel to the GPIO to be controlled 
        if(connected_to_my_network)
          ledcWrite(LED_BUILTIN_CHANNEL, led_builtin_level); //turn on the led, at 20% aproximately
        //digitalWrite(Arp_LED_BUILTIN,HIGH); 
      #endif 
    #endif   
  }


      //----------------------------------------------------WIFI
  connected_to_my_network = start_w_connection();//true if connection is succesfull
  #ifndef PIXEL
      //digitalWrite(Arp_LED_BUILTIN,HIGH);//////////attention/////////////////////////////////////
      //retiré dans 1.3.0.2
  #endif  
  //----------------------------------------------------SERVER
  all_request(); //start server 
  //----------------------------------------------------port

  #ifdef WILULU32
    portW.find_mode();
  #endif
  portA.find_mode();
  #ifdef ARPSCHUINO32
    portB.find_mode();
  #endif
  
  #ifdef WILULU32
    portW.init();
  #endif
  portA.init();       //must be called before portB.init()
  #ifdef ARPSCHUINO32
    portB.init(); 
  
  //----------------------------------------------------INPUTS
  for(int i=16; i<=19;i++) 
    pinMode(Arp[i],INPUT) ;
  #endif

  //----------------------------------------------------I2C
  Device::init();  



  	
/* signal reception task, called every 25ms */
  xTaskCreatePinnedToCore(
    signal_reception,   /* Task function. */
    "signal reception", /* name of task. */
    10000,              /* Stack size of task */
    NULL,               /* parameter of the task */
    3,                  /* priority of the task */
    NULL,               /* Task handle to keep track of created task */ 
    0);                 /* pin task to core 0 */

  // periodic_check task, called every 10 seconds */
    xTaskCreatePinnedToCore(
    periodic_check,     /* Task function. */
    "periodic_check", /* name of task. */
    10000,              /* Stack size of task */
    NULL,               /* parameter of the task */
    2,                  /* priority of the task */
    NULL,               /* Task handle to keep track of created task */ 
    0);                 /* pin task to core 0 */    

  #ifdef BLINK_DEBUG
    xTaskCreate(
      blink_debug, /* Task function. */
      "blink debug", /* name of task. */
      10000, /* Stack size of task */
      NULL, /* parameter of the task */
      2, /* priority of the task */
      NULL); /* Task handle to keep track of created task */ 
  #endif 

  // Serial.print("setup() running on core ");
  // Serial.println(xPortGetCoreID());    
}////////////////////////////////////////////////////////////////////////////////////////////////

void loop() //running on core 1
{
  #ifdef WILULU32
    portW.runAtEachLoop();
  #endif  
  portA.runAtEachLoop();//portA run
  #ifdef ARPSCHUINO32
    portB.runAtEachLoop(); //portB run
  #endif  
  
  for(uint8_t i=0;i<Device::get_nb_devices();i++)
  {
    I2C_port[i]->runAtEachLoop();
  }
}////////////////////////////////////////////////////////////////////////////////////////////////

void signal_reception( void * parameter )//running on core 0
{
  // Serial.print("signal_reception() running on core ");
  // Serial.println(xPortGetCoreID());

  //0=DMX or Artnet in; 1=DMX IN 2=Artnet IN 3=DMX in Artnet out; 4= Artnet in DMX out
  #ifdef WILULU32
    signal_mode=2;//Artnet in only
  #endif
  #ifdef ARPSCHUINO32  
    signal_mode = preferences.getUChar("signal_mode", DFLT_signal_mode);
  #endif
  //Serial.print("signal mode: ");Serial.println(signal_mode);
  if(signal_mode==5)signal_mode=2;/////////////////////////////////////////provisoire!!
  //Serial.print("new signal mode: ");Serial.println(signal_mode);//////////////////////provisoire!!
  String SMode;
  switch(signal_mode)
  {
    case 0 :
      SMode = "DMX or Artnet in";
      break;
    case 1 :
      SMode = "DMX IN";
      break;
    case 2 :
      SMode = "Artnet IN";
      break;
    case 3 :
      SMode = "DMX in Artnet out";
      break;
    case 4 :
      SMode = "Artnet in DMX out";
      break;
    default :
      SMode = "error !";                    
  }
  Serial.print("signal mode: ");Serial.println(SMode);
  #ifdef ARPSCHUINO32 
    if(signal_mode!=2)  //init_DMX();
    {
      DMX1.DMX_init();
    }  
    if(signal_mode!=1 && connected_to_my_network)//init_Artnet();
    {
      Artnet_init();
    }
  #endif
  #ifdef WILULU32
    if(signal_mode==2 && connected_to_my_network)//init_Artnet();
    {
      Artnet_init();
    }
  #endif 
  // if (signal_mode==5) //ESP NOW IN  
  // {

  // } 
  signal_action();  //infinite loop in selected mode. Run every 25ms
  //vTaskDelete( NULL );
}///////////////////////////////////////////////////////////////////////////////////

void periodic_check( void * parameter ) //running on core 0
{ 
    //   Serial.print("periodic_check() running on core ");
    //   Serial.println(xPortGetCoreID());  
  for(;;)/* loop forever */
  { 
    connected_to_my_network = WiFi.isConnected();
    if(connected_to_my_network)
    { 
      #ifdef PIXEL
        //if(!digitalRead(Arp2))////////////////////////////////special Eli !!
          statusLED.setPxCol(BLUE);
      #endif              
      if(checkupdateFlag)
      {
        if(checkupdate("firmware"))
        {
          checkupdate("filesystem");

          delay(2000);
          ESP.restart();
        }
        checkupdateFlag=false;
      }
    }
    else  //if not connected
    {
      #ifdef PIXEL
        //if(!digitalRead(Arp2))////////////////////////////////special Eli !!
          statusLED.setPxCol(ORANGE);
      #endif      
      connected_to_my_network = check_network(); //Try to reconnect
      if(signal_mode!=1 && connected_to_my_network)                 //restart Artnet
      {
        Artnet_init();      
      }
    }      
    vTaskDelay(10000);
  }
  //vTaskDelete( NULL );
}////////////////////////////////////////////////////////////////////////////

#ifdef BLINK_DEBUG//loop to blink without delay///////////////////////////////
  void blink_debug( void * parameter )
  { 
    for(;;)/* loop forever */
    {
      ledState = not(ledState);// if the LED is off turn it on and vice-versa
      // set the LED with the ledState of the variable:
      digitalWrite(blue_led, ledState);
      digitalWrite(green_led, ledState);
      vTaskDelay(1000);
    }
    vTaskDelete( NULL );
  }
#endif////////////////////////////////////////////////////////////////////////////
