#include <arpschuino.h>
#include <ESPAsyncWebServer.h>
#include <SPIFFS.h>
#include <WiFiAP.h>
#include "arp_server.h"
#include "Port.h"
#include <string>
#include <iostream>
#include "_wifi.h"
#include <IPaddress.h>
#include "I2C_port.h"


#include "global.h"/////////////////////////////////////////

#ifdef PIXEL
  #include "pixel.h"
  extern Pixel statusLED;
#endif

#ifdef WILULU32 
  extern Port portW;
#endif
extern Port portA;  //creation des objets port
#ifdef ARPSCHUINO32 
  extern Port portB;
#endif

Preferences preferences;

AsyncWebServer server(80);

extern int address;
extern uint8_t universe;
extern uint8_t signal_mode;

extern bool checkupdateFlag;
extern String new_version;
extern String update_status;
extern String autocalibration_status;

uint8_t lastID=0;

void checkAndWriteString(String keyWord,AsyncWebServerRequest *request,uint8_t page=0,String PORT="a");
void checkAndWriteUChar(String keyWord,AsyncWebServerRequest *request,uint8_t page=0,String PORT="a",uint8_t ID=0);
void checkAndWriteUCharHex(String keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,uint8_t ID=0);

void checkAndWriteUInt(String keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT="a");
void checkAndWriteBool(String keyWord,AsyncWebServerRequest *request,uint8_t page=0,String PORT="a");
void checkAndWriteFloat(String keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT);

String checkAndLoadString(const char * keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,String defaultVal);
uint8_t checkAndLoadUChar(const char * keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,uint8_t defaultVal);
uint16_t checkAndLoadUInt(const char * keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,uint16_t defaultVal);
bool checkAndLoadBool(const char * keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,bool defaultVal);
float checkAndLoadFloat(const char * keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,float defaultVal);

void all_request()
{
  // Serial.print("all_request() running on core ");
  // Serial.println(xPortGetCoreID());
////////////////////charger les fichiers depuis le SPIIFS///////////////////////
  server.on("/", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(SPIFFS, "/index.html", "text/html");
  });

  server.on("/inputs.html", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(SPIFFS, "/inputs.html", "text/html");
  });  
 
  server.on("/ports.html", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(SPIFFS, "/ports.html", "text/html");
  });  

  server.on("/tools.html", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(SPIFFS, "/tools.html", "text/html");
  });  

    server.on("/I2C_device.html", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(SPIFFS, "/I2C_device.html", "text/html");
  });  

  server.on("/style32_1.css", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(SPIFFS, "/style32_1.css", "text/css");
  });  
 
  server.on("/script.js", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(SPIFFS, "/script.js", "text/javascript");
  });

  server.on("/ports.js", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(SPIFFS, "/ports.js", "text/javascript");
  });

  server.on("/OCRAEXT.TTF", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(SPIFFS, "/OCRAEXT.TTF", "font/ttf");
  }); 

  server.on("/favicon.ico", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(SPIFFS, "/favicon.png", "image/png");
  });
//_________________________page network_______________________________

  server.on("/MAC_address", HTTP_GET, [](AsyncWebServerRequest *request) //charger MAcaddress
  {
    String Sdata = String(WiFi.macAddress());
    request->send(200, "text/plain", Sdata);
  }); 

  server.on("/currentIP", HTTP_GET, [](AsyncWebServerRequest *request) //charger currentIP
  {
    String Sdata="192.168.4.1";
    if(WiFi.status() == WL_CONNECTED)
      Sdata = WiFi.localIP().toString();
    request->send(200, "text/plain", Sdata);
  });   

//_________________________page inputs_______________________________

  server.on("/DMX_address", HTTP_GET, [](AsyncWebServerRequest *request) 
  {
    uint16_t temp = preferences.getUInt("DMX_address", DFLT_DMX_address);
    request->send(200, "text/plain", String(temp));
  });

  server.on("/universe", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    uint8_t temp = preferences.getUChar("universe", DFLT_universe); //String(universe);
    request->send(200, "text/plain",String(temp));//Sdata);
  });


/////////////////////////////////reboot////////////////////////////
  server.on("/reboot", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    Serial.println("arpschuino32 will reboot");
    request->send(200, "text/plain", "arpschuino32 is rebooting !");
    delay(1000);
    ESP.restart();
  }); 

//////////////////////////////// scan_i2c ////////////////////////////
  server.on("/scan_i2c", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(200, "text/plain", Device::scan());
  });   
  //____________________________________________________________________
  //_________________________page outputs_______________________________// 


  /////////////////////////////////set///////////////////////////////////////////

  ////////////////////////////////////////////////////////////////////////////////////////  
//______________________________________divers_______________________________//

  server.on("/get_update_status", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(200, "text/plain", update_status);
  });

    server.on("/get_autocalibration_status", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    request->send(200, "text/plain", autocalibration_status);
  });

  server.on("/led_on", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    #ifdef PIXEL
      // if(WiFi.isConnected())//inutile : si non connecté on y a pas acces !
      // { 
        statusLED.setPxCol(BLUE);
      // }
      // else
      // {
      //   statusLED.setPxCol(ORANGE);
      // }
    #else    
      #ifdef ARPSCHUINO32
        digitalWrite(Arp_LED_BUILTIN, HIGH);
      #endif
      #ifdef WILULU32
        ledcWrite(LED_BUILTIN_CHANNEL, led_builtin_level);
      #endif  
    #endif    
    request->send(200);
  });

  server.on("/led_off", HTTP_GET, [](AsyncWebServerRequest *request)
  {
    #ifdef PIXEL
      statusLED.setPxCol(BLACK);
    #else       
      #ifdef ARPSCHUINO32
        digitalWrite(Arp_LED_BUILTIN, LOW);
      #endif
      #ifdef WILULU32
        ledcWrite(LED_BUILTIN_CHANNEL, 0);
      #endif  
    #endif       
    request->send(200);
  });  

////////////////////////////////////////global////////////////////////////////////////////////////

  server.on("/get_request", HTTP_POST, [](AsyncWebServerRequest *request) {//recoit de requetes et renvoie les valeurs
    #ifdef ajax_verbose
      Serial.println();
      Serial.println("get_request");
    #endif
    bool need_reboot=false;
    String Sdata;//////////////////////////attention!!
    if(request->hasParam("PAGE", true))//page : 0 index, 1 input, 2 output, 3 divers
    {
      String message = request->getParam("PAGE", true)->value();//VAL0, la page
      uint8_t page = message.toInt();
      #ifdef ajax_verbose
        Serial.print("page ");Serial.println(message);
      #endif

      switch(page)
      {
        case 0:{//index
          if(request->hasParam("AP_ssid", true)){
            Sdata= preferences.getString("AP_ssid",DFLT_AP_ssid);
          }
          else if(request->hasParam("AP_pass", true)){
            Sdata= preferences.getString("AP_pass", DFLT_AP_pass);
          }
          else if(request->hasParam("hide_SSID", true)){
            Sdata= preferences.getBool("hide_SSID", DFLT_hide_SSID);
          }
          else if(request->hasParam("NW_ssid", true)){
            Sdata= preferences.getString("NW_ssid", DFLT_NW_ssid);
          }
          else if(request->hasParam("NW_pass", true)){
            Sdata= preferences.getString("NW_pass", DFLT_NW_pass);
          }
          else if(request->hasParam("NW_ssid2", true)){
            Sdata= preferences.getString("NW_ssid2", DFLT_NW_ssid2);
          }
          else if(request->hasParam("NW_pass2", true)){
            Sdata= preferences.getString("NW_pass2", DFLT_NW_pass2);
          }
          else if(request->hasParam("NW_timeout", true)){
            Sdata= preferences.getUChar("NW_timeout", DFLT_NW_timeout);
          }
          else if(request->hasParam("hostname", true)){
            Sdata= preferences.getString("hostname", DFLT_hostname);
          }          
          else if(request->hasParam("mode_static", true)){
            Sdata= preferences.getBool("mode_static", DFLT_mode_static);
          }
          else if(request->hasParam("fixIP", true)){
            Sdata= preferences.getString("fixIP", DFLT_fixIP);
          }
          else if(request->hasParam("fixGateway", true)){
            Sdata= preferences.getString("fixGateway", DFLT_fixGateway);
          }
          else if(request->hasParam("fixSubnet", true)){
            Sdata= preferences.getString("fixSubnet", DFLT_fixSubnet);
          }
          else if(request->hasParam("2SSID", true)){
            Sdata= preferences.getBool("2SSID", DFLT_2SSID);
          }          
          break;
        }
        case 1:{//input
          if(request->hasParam("signal_mode", true))
          {
            uint8_t MODE = checkAndLoadUChar("signal_mode",request,1,"",DFLT_signal_mode);
            switch(MODE)
            {
              case 0: { 
                Sdata = "DMX or Artnet IN";
                break;
              } 
              case 1:  {  
                Sdata = "DMX IN";   
                break;
              }
              case 2:  { //servo
                Sdata = "Artnet IN";
                break;               
              }
              case 3:  {  
                Sdata = "DMX IN > Artnet OUT";   
                break;
              }
              case 4:  {  
                Sdata = "Artnet IN > DMX OUT";   
                break;
              } 
              case 5:  {  
                Sdata = "ESP NOW IN";   
                break;
              }                            
            }    
          }

        }
        case 2:{//port
          String PORT;  //char ??
          if(request->hasParam("PORT", true))/////VAL1, le port
          {
            PORT = request->getParam("PORT", true)->value();
            #ifdef ajax_verbose
              Serial.print("port ");Serial.print(PORT); Serial.print(" ");
            #endif
          }
          if (request->hasParam("port_address", true))
          {
            #ifdef WILULU32
              if(PORT=="W")
              {            
                Sdata=address;
              }
            #endif            
            if(PORT=="A")
            {
              #ifdef ARPSCHUINO32
                Sdata = address;
              #endif
              #ifdef WILULU32
                Sdata = address + portW.getNbDmxChannels();
              #endif 
            }
            #ifdef ARPSCHUINO32
              else if(PORT=="B")
              {            
                Sdata = address + portA.getNbDmxChannels();
              }
            #endif 
            else if(PORT=="I2C")
            {             
              #ifdef ARPSCHUINO32            
                Sdata = address + portA.getNbDmxChannels() + portB.getNbDmxChannels();
              #endif
             #ifdef WILULU32 
                Sdata = address + portW.getNbDmxChannels() + portA.getNbDmxChannels();
              #endif 
            }                                                                                        
          }

          if(request->hasParam("MODE", true))/////mode
          {
            uint8_t MODE;
            #ifdef WILULU32 //port A inactif par defaut
              if(PORT=="A")
                MODE=checkAndLoadUChar("mode",request,2,PORT,255);//port A inactif par defaut
              if(PORT=="W")
                MODE=checkAndLoadUChar("mode",request,2,PORT,DFLT_PORT_MODE);//DFLT_PORT_MODE 0
            #else    
              MODE=checkAndLoadUChar("mode",request,2,PORT,DFLT_PORT_MODE);//DFLT_PORT_MODE 
            #endif            
            switch(MODE)
            {
              case 0: {  //pwm
                Sdata = "pwm";
                break;
              } 
              case 1:  {  //on/off
                Sdata = "on/off";   
                break;
              }
              case 2:  { //servo
                Sdata = "servo";
                break;               
              }
              case 3:  {  
                Sdata = "stepper";   
                break;
              }
              case 4:  {  
                Sdata = "CCmotor";   
                break;
              }              
              //////////////////////////////
              case 20:  {  
                Sdata = "inputs";   
                break;
              }              
              //////////////////////////////              
              case 254:  { 
                Sdata = "custom";
                break;               
              }              
              default:
                Sdata = "inactive";
            }    
          }
          else
          {
            if(request->hasParam("NbDmxChannels", true))/////
            {
            
              if(PORT=="A")
                Sdata=portA.getNbDmxChannels();
              #ifdef ARPSCHUINO32  
                else if(PORT=="B")
                  Sdata=portB.getNbDmxChannels();
              #endif 
              #ifdef WILULU32  
                else if(PORT=="W")
                  Sdata=portW.getNbDmxChannels();
              #endif                 
            }  
            // PWM //          
            if(request->hasParam("dmxRes", true))/////resolution DMX
            {
              Sdata=checkAndLoadBool("dmxRes",request,2,PORT,DFLT_dmxRes);
            }
            else if(request->hasParam("PWM_resolution", true))/////resolution PWM
            {
              Sdata=checkAndLoadUChar("PWM_resolution",request,2,PORT,DFLT_PWM_resolution);
            }
            else if(request->hasParam("pwmCurve", true))/////curve
            {
              Sdata=checkAndLoadBool("pwmCurve",request,2,PORT,DFLT_pwmCurve);
            }            
            else if(request->hasParam("pwmFreq", true))
            {
              uint32_t next_freq = 40000000;
              uint8_t next_resol = 14;
              if (PORT=="A"){
                next_resol = portA.load("PWM_resolution",next_resol);
              }
              #ifdef ARPSCHUINO32 
                else if (PORT=="B"){
                  next_resol = portB.load("PWM_resolution",next_resol);
                }
              #endif 
              #ifdef WILULU32 
                else if (PORT=="W"){
                  next_resol = portW.load("PWM_resolution",next_resol);
                }
              #endif               
              for(int i=1;i<next_resol;i++){
                next_freq=next_freq/2;
              }
              Sdata = String(next_freq);
            } 
            //on/off//           
            else if(request->hasParam("trigger", true))
            {
              Sdata=checkAndLoadUChar("trigger",request,2,PORT,DFLT_trigger);
            } 
            else if(request->hasParam("trig_percent", true))
            {
              uint8_t trigger= 128;
              uint8_t percent = 0;
              if (PORT=="A"){
                trigger = portA.load("trigger",trigger);
              }
              #ifdef ARPSCHUINO32 
                else if (PORT=="B"){
                  trigger = portB.load("trigger",trigger);
                }
              #endif
              percent=trigger*100/255;
              Sdata = String(percent); 
            }  
            else if(request->hasParam("inverted", true))
            {
              Sdata=checkAndLoadBool("inverted",request,2,PORT,DFLT_inverted);
            }
            //servo//
            else if(request->hasParam("servo", true)) 
            {
              String Num = request->getParam("servo", true)->value(); 
              String str = Num + "servoActive"; 
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_Active);
              }
              str = Num + "angle";
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadUChar(key,request,2,PORT,DFLT_angle);
              }  
              str = Num + "servoInverted";
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_inverted);
              } 
              str = Num + "detach";
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_detach);
              }                                                                                  
            }            
            ///////////////////////////////////////////////////////////////
            else if(request->hasParam("stpDrivMode", true))
            {
              Sdata=checkAndLoadUChar("stpDrivMode",request,2,PORT,DFLT_stpDrivMode);//default 1 : stp/dir
            }             
            else if(request->hasParam("stepper", true))
            { 
              String stepperNum = request->getParam("stepper", true)->value(); 

              String str = stepperNum + "stpPerRevol";
              if(request->hasParam(str, true))//////////////////////////
              {
                  const char * key = str.c_str();
                  Sdata=checkAndLoadUInt(key,request,2,PORT,DFLT_SPR);
              }
              str = stepperNum + "stpActive"; 
              if(request->hasParam(str, true))//////////////////////////
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_Active);
              } 
              str = stepperNum + "_rpm_min";                        
              if(request->hasParam((str), true ))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadUInt(key,request,2,PORT,DFLT_Min);
              } 
              str = stepperNum + "_rpm_max";
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadUInt(key,request,2,PORT,DFLT_Max);
              } 
              str = stepperNum + "_revol";
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadFloat(key,request,2,PORT,DFLT_Revol);
              }
              str = stepperNum + "_accel";
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadFloat(key,request,2,PORT,DFLT_Accel);
              }  ///////////////////////////////////////////          
              str = stepperNum + "stpInverted";
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_inverted);
              }               
              str = stepperNum + "stpAction";
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_Action);
              } 
              str = stepperNum + "stp_dmxRes";    
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_dmxRes);
              } 
              str = stepperNum + "stpZeroSW"; 
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_SWITCH);
              }            
              str = stepperNum + "stpZero_i";      
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadUChar(key,request,2,PORT,DFLT_input);
              }
              str = stepperNum + "stpHomingSW";               
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_stpHomingSW);
              } 
              str = stepperNum + "stpHomSpeed";  
              if(request->hasParam(str, true))/////////////stpHomSpeed
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadUChar(key,request,2,PORT,DFLT_stpHomSpeed);
              }                                          
              str = stepperNum + "stpEndSW";               
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_SWITCH);
              } 
              str = stepperNum + "stpEnd_i";      
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadUChar(key,request,2,PORT,DFLT_input);
              }
              //////////////////// autocalibration ////////////////
              if(request->hasParam("autocalibration", true))
              {
                Serial.println("autocalibration request");

                str = stepperNum + "autocalib";
                const char * key = str.c_str();
                bool do_autocal=true;
                //bool default_val=false;
                if (PORT=="A")
                {
                  portA.record(key,do_autocal);
                  //Serial.print("autocal = ");Serial.println(portA.load(key, default_val));
                }
                #ifdef ARPSCHUINO32   
                  else if(PORT=="B")
                    portB.record(key,do_autocal);
                #endif 
                need_reboot=true;
                Sdata = "autocalibration request";//update_status;
              }                                                        
            }
            else if(request->hasParam("CCmotor", true)) 
            {
              String Num = request->getParam("CCmotor", true)->value(); 
              String str = Num + "CCActive"; 
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_Active);
              }
              str = Num + "CCdvrType";//CCdvrType//////////////////////////
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadUChar(key,request,2,PORT,DFLT_CC_driver_type);
                  //Serial.print(" key: ");Serial.println(key);////////////debug/////////
              }               

              str = Num + "CCInverted";
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_inverted);
              } 
              str = Num + "thresold";
              if(request->hasParam(str, true))
              {
                  const char * key = str.c_str();
                  Sdata=checkAndLoadUChar(key,request,2,PORT,DFLT_CC_threshold);
              }

              String str_percent = Num + "thresold_percent";
              if(request->hasParam(str_percent, true))
              {
                #ifdef ajax_verbose
                  Serial.print(Num);Serial.print("thresold ");
                #endif
                //uint8_t thresold= 1;
                uint8_t percent = 0;
                // if (PORT=="A"){
                //   thresold = portA.load(Num + "thresold",thresold);
                // }
                // #ifdef ARPSCHUINO32 
                //   else if (PORT=="B"){
                //     thresold = portB.load(Num + "thresold",thresold);
                //   }
                // #endif
                str = Num + "thresold";
                const char * key = str.c_str();
                uint8_t thresold= checkAndLoadUChar(key,request,2,PORT,DFLT_CC_threshold);

                percent=thresold*100/255;
                #ifdef ajax_verbose
                  Serial.print("%");
                #endif
                Sdata = String(percent);
              }

              str = Num + "CC_freq";
              if(request->hasParam(str, true))
              {
                const char * key = str.c_str();
                Sdata=checkAndLoadUInt(key,request,2,PORT,DFLT_CC_freq);/////////////////////////////////////////////
              } 

              str = Num + "CCZeroSW"; 
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_SWITCH);
              }            
              str = Num + "CCZero_i";      
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadUChar(key,request,2,PORT,DFLT_input);
              }              
              str = Num + "CCEndSW"; 
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadBool(key,request,2,PORT,DFLT_SWITCH);
              } 
              str = Num + "CCEnd_i";      
              if(request->hasParam(str, true))
              {
                  const char * key = (str).c_str();
                  Sdata=checkAndLoadUChar(key,request,2,PORT,DFLT_input);
              }                                                                   
            }
            else if(request->hasParam("device_request", true))
            {
              uint8_t nb_devices = preferences.getUChar("nb_devices", 0); //get the number of recorded devices
              if(nb_devices<6)
                preferences.putUChar("nb_devices", nb_devices+1);           //re-records with one more device
              Sdata = nb_devices;                                       //returns the ID  
            }                         
            else if(request->hasParam("nb_devices", true))
            {
              Sdata = preferences.getUChar("nb_devices", 0);
            } 
            else if(request->hasParam("ID", true))
            {
              Sdata = lastID;
              lastID++;
            }
            else if(request->hasParam("I2Cdeleted", true))
            {
              String Num = request->getParam("deviceID", true)->value(); 
              String str = Num + "I2Cdeleted";
              const char * key = str.c_str();

              Sdata=checkAndLoadBool(key,request,2,"I2C",0);           
            }            
            else if(request->hasParam("I2Caddress", true))
            {
              String Num = request->getParam("deviceID", true)->value(); 
              String str = Num + "I2Caddress";
              const char * key = str.c_str();
              Sdata=checkAndLoadUChar(key,request,2,"I2C",255); /////////quelle valeur par defaut ???          
            }
            else if(request->hasParam("I2Cdevice", true))
            {
              String Num = request->getParam("deviceID", true)->value(); 
              String str = Num + "I2Cdevice";
              const char * key = str.c_str();
              Sdata=checkAndLoadString(key,request,2,"I2C","none");  
            }                                                                                       
          }
          break;
        }
        case 3:{//divers
          if(request->hasParam("update", true))
          {
            Serial.print("update request ");
            new_version= request->getParam("version", true)->value();
            Serial.println(new_version);
            checkupdateFlag=true;
            Sdata = update_status;
          }
          else if(request->hasParam("LED_builtin", true))
          {
            Sdata=checkAndLoadBool("LED_builtin",request,3,"",1);
          }
          #ifdef WILULU32 
            else if(request->hasParam("levelLEDB", true))
            {
              Sdata=checkAndLoadUChar("levelLEDB",request,3,"",50);
              led_builtin_level=Sdata.toInt();
              #ifdef PIXEL
                statusLED.setPxCol(BLUE);
              #else
                ledcWrite(LED_BUILTIN_CHANNEL, led_builtin_level);
              #endif
            }  
          #endif                  
          break;
        }
      }
      #ifdef ajax_verbose
        Serial.print(" : ");
        Serial.println(Sdata);
      #endif
    }  
    request->send(200, "text/plain", Sdata);
    if(need_reboot)
    {
      delay(50);
      ESP.restart();////reboot to do autocalibration 
    }       
  });

  server.on("/set_request", HTTP_POST, [](AsyncWebServerRequest *request) {//recoit de requetes et enregistre les variables ds l'eeprom
    #ifdef ajax_verbose
      Serial.println("set_request");
    #endif
    if(request->hasParam("PAGE", true))//page : 0 index, 1 input, 2 ports, 3 tools
    {
      String message0 = request->getParam("PAGE", true)->value();//VAL0, la page
      uint8_t page = message0.toInt();
      #ifdef ajax_verbose
        Serial.print("page ");Serial.println(message0);
      #endif

      switch(page)
      {
        case 0:{//index
          checkAndWriteString("AP_ssid",request);
          checkAndWriteString("AP_pass",request);
          checkAndWriteBool("hide_SSID",request);
          checkAndWriteString("NW_ssid",request);
          checkAndWriteString("NW_pass",request);
          checkAndWriteBool("2SSID",request);
          checkAndWriteString("NW_ssid2",request);
          checkAndWriteString("NW_pass2",request);          

          checkAndWriteUChar("NW_timeout", request);
          checkAndWriteString("hostname",request);
          checkAndWriteBool("mode_static",request);
          checkAndWriteString("fixIP",request);
          checkAndWriteString("fixGateway",request);
          checkAndWriteString("fixSubnet",request);
          break;
        }
        case 1:{
          checkAndWriteUChar("signal_mode",request,1); 
          checkAndWriteUInt("DMX_address",request,1); 
          checkAndWriteUChar("universe",request,1);    
          break;
        }
        case 2:{//output (ports)
          String PORT;
          if(request->hasParam("PORT", true))/////VAL1, le port
          {
            PORT = request->getParam("PORT", true)->value();
            Serial.print("port ");Serial.print(PORT);
          }
          checkAndWriteUChar("mode",request,2,PORT);
          checkAndWriteBool("dmxRes",request,2,PORT);
          checkAndWriteUChar("PWM_resolution",request,2,PORT);
          checkAndWriteBool("pwmCurve",request,2,PORT);
          checkAndWriteUChar("trigger",request,2,PORT);
          checkAndWriteBool("inverted",request,2,PORT);

          if(request->hasParam("servo", true))
          {
            String str = request->getParam("servo", true)->value();
            Serial.print(", servo n° ");Serial.print(str);Serial.print(" ");
            checkAndWriteBool(str + "servoActive",request,2,PORT);
            checkAndWriteUChar(str + "angle",request,2,PORT);
            checkAndWriteBool(str + "servoInverted",request,2,PORT);
            checkAndWriteBool(str + "detach",request,2,PORT);
          }          

          checkAndWriteUChar("stpDrivMode",request,2,PORT);
          if(request->hasParam("stepper", true))
          {
            String str = request->getParam("stepper", true)->value();
            Serial.print(", stepper n° ");Serial.print(str);Serial.print(" ");
            checkAndWriteBool(str + "stpActive",request,2,PORT);
            checkAndWriteUInt(str + "stpPerRevol",request,2,PORT);
            checkAndWriteUInt(str + "_rpm_min",request,2,PORT);
            checkAndWriteUInt(str + "_rpm_max",request,2,PORT);
            checkAndWriteFloat(str + "_revol",request,2,PORT);
            checkAndWriteFloat(str + "_accel",request,2,PORT);
            checkAndWriteBool(str + "stpInverted",request,2,PORT);
            checkAndWriteBool(str + "stpAction",request,2,PORT);
            checkAndWriteBool(str + "stp_dmxRes",request,2,PORT); 
            checkAndWriteBool(str + "stpZeroSW",request,2,PORT);
            checkAndWriteUChar(str + "stpZero_i",request,2,PORT);
            checkAndWriteBool(str + "stpHomingSW",request,2,PORT);
            checkAndWriteUChar(str + "stpHomSpeed",request,2,PORT);
            checkAndWriteBool(str + "stpEndSW",request,2,PORT);
            checkAndWriteUChar(str + "stpEnd_i",request,2,PORT);                             
          }
          if(request->hasParam("CCmotor", true))////////////////////////////////////////////
          {
            String str = request->getParam("CCmotor", true)->value();
            Serial.print(", DCmotor n° ");Serial.print(str);Serial.print(" ");
            checkAndWriteBool(str + "CCActive",request,2,PORT);
            checkAndWriteUChar(str + "CCdvrType",request,2,PORT);//CCdvrType//
            checkAndWriteBool(str + "CCInverted",request,2,PORT);
            checkAndWriteUChar(str + "thresold",request,2,PORT);
            checkAndWriteUInt(str + "CC_freq",request,2,PORT);//////////////// 
            checkAndWriteBool(str + "CCZeroSW",request,2,PORT);
            checkAndWriteUChar(str + "CCZero_i",request,2,PORT);  
            checkAndWriteBool(str + "CCEndSW",request,2,PORT);
            checkAndWriteUChar(str + "CCEnd_i",request,2,PORT);        
          }
       
          ///////////////////////////////// I2C //////////////////////////////////////////////////
          if(PORT=="I2C"){
            String string_nb_devices;
            if(request->hasParam("nb_devices", true))/////
            {
              string_nb_devices = (request->getParam("nb_devices", true)->value());
              preferences.putUChar("nb_devices", string_nb_devices.toInt());
              Serial.print(" device ");Serial.println(string_nb_devices);
            }
            else if(request->hasParam("add_devices", true))/////
            {
              int nb_devices = preferences.getUChar("nb_devices", 0);
              nb_devices++;
              preferences.putUChar("nb_devices", nb_devices);
              Serial.print(" device ");Serial.println(nb_devices);
            }  

            else if(request->hasParam("device", true))
            {
              Serial.println("request->hasParam device");
              String str = request->getParam("device", true)->value();
              Serial.print(" device ");Serial.print(str);

              checkAndWriteUCharHex(str + "I2Caddress",request,2,"I2C");
              checkAndWriteString(str + "I2Cdevice",request,2,"I2C");
              checkAndWriteBool(str + "I2Cdeleted",request,2,"I2C");

              if(request->hasParam("substract_devices", true))/////
              {
                Serial.println("request->hasParam substract_devices");
                int nb_devices = preferences.getUChar("nb_devices", 0);
                uint8_t ID=str.toInt();
                Device::delete_devices(ID);
                nb_devices--;
                preferences.putUChar("nb_devices", nb_devices);
                Serial.print(" device ");Serial.println(nb_devices);
              }               
            }                                
          }
          break;
        }
        case 3:{//divers
            checkAndWriteBool("LED_builtin",request,3);
            #ifdef WILULU32
              checkAndWriteUChar("levelLEDB",request,3);
              #ifdef PIXEL 
              ///////////////////////////////led_builtin_level=Sdata.toInt();
                ////////////////////////////////////statusLED.setPxCol(BLUE);
              #endif
            #endif
          break;
        }
      }
    }
    request->send(204);
  });
////////////////////////////////////////////////////////////////////////////////////////////
  server.begin();
  Serial.println("Server active! "); 
  Serial.println(); 
  vTaskDelay(1);
}


void init_SPIFFS()
{
 if(!SPIFFS.begin())
  {
    Serial.println("SPIFFS error...");
    return;
  }
  File root = SPIFFS.open("/");
  File file = root.openNextFile();

  while(file)
  {
    Serial.print("File: ");
    Serial.println(file.name());
    file.close();
    file = root.openNextFile();
  }
  Serial.println("\n");
}

void init_preferences()
{
  preferences.begin("wifi_datas", false);

  address = preferences.getUInt("DMX_address", DFLT_DMX_address); 
  Serial.print("DMX address : ");
  Serial.println(address);  


  universe = preferences.getUChar("universe", DFLT_universe); 
  Serial.print("artnet universe : ");
  Serial.println(universe); 

  #ifdef ARPSCHUINO32 
    signal_mode = preferences.getUChar("signal_mode", DFLT_signal_mode);
    Serial.print("signal mode : ");
    String SMODE;
    switch(signal_mode)
    {
      case 0: { 
        SMODE = "DMX or Artnet IN";
        break;
      } 
      case 1:  {  
        SMODE = "DMX IN";   
        break;
      }
      case 2:  { //servo
        SMODE = "Artnet IN";
        break;               
      }
      case 3:  {  
        SMODE = "DMX IN > Artnet OUT";   
        break;
      }
      case 4:  {  
        SMODE = "Artnet IN > DMX OUT";   
        break;
      }              
    }   
    Serial.println(SMODE); 
  #endif
  #ifdef WILULU32
    led_builtin_level = preferences.getUChar("levelLEDB", 50); 
    Serial.print("level LED BUILTIN: ");
    Serial.println(led_builtin_level);
  #endif 
}


void checkAndWriteString(String keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT)
{
  if(request->hasParam(keyWord, true))
  {
    String message = request->getParam(keyWord, true)->value();
    if(message!="")
    { 
      const char * key = keyWord.c_str(); 
      if(page==0)
        preferences.putString(key,message);
        //writeJsonString(NWConfig,key,message);
      else if(page==2)
      {
        if (PORT=="A")
          portA.record(key,message);
        #ifdef ARPSCHUINO32   
          else if(PORT=="B")
            portB.record(key,message); 
        #endif  
        #ifdef WILULU32   
          else if(PORT=="W")
            portW.record(key,message); 
        #endif          
        else if(PORT=="I2C")
          preferences.putString(key, message);                 
      }    
            Serial.println("String");///////////////////////////////debug/////////
  
      Serial.print(" New ");
      Serial.print(keyWord);
      Serial.print(" : ");
      Serial.println(message);
    }
  }
}

void checkAndWriteUChar(String keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,uint8_t ID)
{
  if(request->hasParam(keyWord, true))
  {
    String message = request->getParam(keyWord, true)->value();
    if(message!="")
    { 
      const char * key = keyWord.c_str(); 
      uint8_t temp = message.toInt();
      switch(page)
      {
       // case 0:      
          //writeJsonUchar(NWConfig,key,temp);
        //   preferences.putUChar(key, temp);
        //   break;
        case 1:  
          preferences.putUChar(key, temp);
          break;
        case 2:
          if (PORT=="A")
            portA.record(key,temp);
          #ifdef ARPSCHUINO32   
            else if(PORT=="B")
              portB.record(key,temp);
          #endif
          #ifdef WILULU32   
            else if(PORT=="W")
              portW.record(key,temp); 
          #endif             
          else if(PORT=="I2C")
          {
            preferences.putUChar(key, temp);
          }  
          break; 
        default :
          preferences.putUChar(key, temp);       
      }
            //Serial.println("Uchar");///////////////////////////////debug/////////
            //Serial.println(temp);///////////////////////////////debug/////////
      Serial.print(" New ");
      Serial.print(keyWord);
      Serial.print(" : ");
      Serial.println(message);
    }
  }
}

void checkAndWriteUCharHex(String keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,uint8_t ID)
{
  if(request->hasParam(keyWord, true))
  {
    String message = request->getParam(keyWord, true)->value();
    if(message!="")
    { 
      uint8_t temp;
      if(message[0]=='0' && message[1]=='x')
      {
        Serial.println();Serial.print("this is a hex nb ! 0x");//Serial.print(message[0]);Serial.println(message[1]);
        message.remove(0,2);
        Serial.println(message);
        //convert to hexa :
        byte tens = (message[0] < '9') ? message[0] - '0' : message[0] - '7';
        byte ones = (message[1] < '9') ? message[1] - '0' : message[1] - '7';
        temp = (16 * tens) + ones;
        Serial.print("converted : ");Serial.println(temp);
      }
      else temp = message.toInt();

      const char * key = keyWord.c_str();
      switch(page)
      {
       // case 0:      
          //writeJsonUchar(NWConfig,key,temp);
        //   preferences.putUChar(key, temp);
        //   break;
        case 1:  
          preferences.putUChar(key, temp);
          break;
        case 2:
          if (PORT=="A")
            portA.record(key,temp);
          #ifdef ARPSCHUINO32   
            else if(PORT=="B")
              portB.record(key,temp);
          #endif
          #ifdef WILULU32   
            else if(PORT=="W")
              portW.record(key,temp); 
          #endif           
          else if(PORT=="I2C")
          {
            preferences.putUChar(key, temp);
          }  
          break; 
        default :
          preferences.putUChar(key, temp);       
      }
            Serial.println("charHex");///////////////////////////////debug/////////

      Serial.print(" New ");
      Serial.print(keyWord);
      Serial.print(" : ");
      Serial.println(message);
    }
  }
}

void checkAndWriteUInt(String keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT)
{
  if(request->hasParam(keyWord, true))
  {
    String message = request->getParam(keyWord, true)->value();
    if(message!="")
    { 
      const char * key = keyWord.c_str(); 
      uint16_t temp = message.toInt();
      switch(page)
      {
        case 2:
          if (PORT=="A")
            portA.record(key,temp);
          #ifdef ARPSCHUINO32             
            else if(PORT=="B")
              portB.record(key,temp);
          #endif 
          #ifdef WILULU32   
            else if(PORT=="W")
              portW.record(key,temp); 
          #endif              
          else if(PORT=="I2C")
            preferences.putUInt(key, temp);            
          break;
        default:
          preferences.putUInt(key, temp);        
      }
      //Serial.println("uint");///////////////////////////////debug/////////
      //Serial.println(temp);///////////////////////////////debug/////////
      Serial.print(" New ");
      Serial.print(keyWord);
      Serial.print(" : ");
      Serial.println(message);
    }
  }
}

void checkAndWriteBool(String keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT)
{
  if(request->hasParam(keyWord, true))
  {
    String message = request->getParam(keyWord, true)->value();
    if(message!="")
    { 
      const char * key = keyWord.c_str();
      uint8_t temp;
      if(message=="true")
        temp=1;
      else if(message=="false")
        temp=0;
      else
        temp = message.toInt();
      if(page==2)
      {
        
        if (PORT=="A")
          portA.record(key,temp);
          #ifdef ARPSCHUINO32             
            else if(PORT=="B")
              portB.record(key,temp);
          #endif  
          #ifdef WILULU32   
            else if(PORT=="W")
              portW.record(key,temp); 
          #endif           
        else if(PORT=="I2C")
          preferences.putBool(key, temp);      
      }      
      else 
        preferences.putBool(key, temp);

      Serial.print(" New ");  
      Serial.print(keyWord);
      Serial.print(" : ");
      Serial.println(temp);
    }
  }
}

void checkAndWriteFloat(String keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT)
{
  if(request->hasParam(keyWord, true))
  {
    String message = request->getParam(keyWord, true)->value();
    if(message!="")
    { 
      const char * key = keyWord.c_str(); 
      float temp = message.toFloat();
      switch(page)
      {
        case 2:
          if (PORT=="A")
            portA.record(key,temp);
          #ifdef ARPSCHUINO32             
            else if(PORT=="B")
              portB.record(key,temp);
          #endif 
          #ifdef WILULU32   
            else if(PORT=="W")
              portW.record(key,temp); 
          #endif           
          else if(PORT=="I2C")
            preferences.putFloat(key, temp);           
          break;
        default:
          preferences.putFloat(key, temp);       
      }
      Serial.print(" New ");
      Serial.print(keyWord);
      Serial.print(" : ");
      Serial.println(message);
    }
  }
}
//////////////////////////////////////////////////////////////////////////////////
String checkAndLoadString(const char * keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,String defaultVal)
{
  String val=defaultVal;
    switch(page)
    {
      case 2:{
        if (PORT=="A")
          val= portA.load(keyWord,defaultVal);
        #ifdef ARPSCHUINO32  
          else if(PORT=="B")
            val= portB.load(keyWord,defaultVal);
        #endif 
        #ifdef WILULU32   
          else if(PORT=="W")
            val= portW.load(keyWord,defaultVal); 
        #endif           
        else if(PORT=="I2C")
          val= preferences.getString(keyWord,defaultVal);
        break;
      default:
        val= preferences.getString(keyWord,defaultVal);             
      }        
    }
    #ifdef ajax_verbose
      Serial.print(keyWord);
    #endif
    return val;
}


uint8_t checkAndLoadUChar(const char * keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,uint8_t defaultVal)
{
  uint8_t val=defaultVal;
    switch(page)
    {

      case 2:{
        if (PORT=="A")
          val= portA.load(keyWord,defaultVal);
        #ifdef ARPSCHUINO32  
          else if(PORT=="B")
            val= portB.load(keyWord,defaultVal);
        #endif 
        #ifdef WILULU32   
          else if(PORT=="W")
            val= portW.load(keyWord,defaultVal); 
        #endif           
        else 
          val= preferences.getUChar(keyWord,defaultVal);
        break;
      default:
        val= preferences.getUChar(keyWord,defaultVal);             
      }        
    }
    #ifdef ajax_verbose
      Serial.print(keyWord);
    #endif
    return val;
}

uint16_t checkAndLoadUInt(const char * keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,uint16_t defaultVal)
{
  uint16_t val=defaultVal;
    switch(page)
    {
      case 2:{
        if (PORT=="A")
          val= portA.load(keyWord,defaultVal);
        #ifdef ARPSCHUINO32  
          else if(PORT=="B")
            val= portB.load(keyWord,defaultVal);
        #endif 
        #ifdef WILULU32   
          else if(PORT=="W")
            val= portW.load(keyWord,defaultVal); 
        #endif           
        break;
      default:
         val = preferences.getUInt(keyWord,defaultVal); ///////////getUint?????????????,
      }        
    }
    #ifdef ajax_verbose
      Serial.print(keyWord);
    #endif
    return val;
}

bool checkAndLoadBool(const char * keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,bool defaultVal)
{
  bool val=defaultVal;
    switch(page)
    {
      case 2:{
        if (PORT=="A")
          val= portA.load(keyWord,defaultVal);
        #ifdef ARPSCHUINO32  
          else if(PORT=="B")
            val= portB.load(keyWord,defaultVal);
        #endif  
        #ifdef WILULU32   
          else if(PORT=="W")
            val= portW.load(keyWord,defaultVal); 
        #endif          
        break;
      default:
         val = preferences.getBool(keyWord,defaultVal);         
      }        
    }
    #ifdef ajax_verbose
      Serial.print(keyWord);
    #endif
    return val;
}

float checkAndLoadFloat(const char * keyWord,AsyncWebServerRequest *request,uint8_t page,String PORT,float defaultVal)
{
  float val=defaultVal;
    switch(page)
    {
      case 2:{
        if (PORT=="A"){
          val= portA.load(keyWord,defaultVal);
          }
        #ifdef ARPSCHUINO32  
          else if(PORT=="B")
            val= portB.load(keyWord,defaultVal);
        #endif 
        #ifdef WILULU32   
          else if(PORT=="W")
            val= portW.load(keyWord,defaultVal); 
        #endif           
        break;
      default:
        val = preferences.getFloat(keyWord,defaultVal);
      }        
    }
    #ifdef ajax_verbose
      Serial.print(keyWord);
    #endif
    return val;
}


void record(const char * key,uint32_t val)
{
  preferences.putUInt(key, val);
}