#include "global.h"

#include <ESPAsyncWebServer.h>
#include <WiFiAP.h>
#include <HTTPClient.h>
#include <Update.h>
#include "_wifi.h"
#include "arp_server.h"
#include <Preferences.h>
#include <arpschuino.h>
//#include <arpschuino32_core.h>
#include <ESPmDNS.h>

#ifdef PIXEL
  #include "pixel.h"
  extern Pixel statusLED;
#endif

HTTPClient client;
// Global variables
int totalLength;       //total size of firmware 
int currentLength = 0; //current size of written 
extern Preferences preferences;
String new_version;
String update_status="search this version";

  

void start_acces_point()
{
  Serial.println("Configuring access point...");
  String str_AP_ssid = preferences.getString("AP_ssid",DFLT_AP_ssid);
  const char* AP_ssid = str_AP_ssid.c_str();
  String str_AP_password = preferences.getString("AP_pass", DFLT_AP_pass);
  const char* AP_password = str_AP_password.c_str();
  bool show_hide = preferences.getBool("hide_SSID",DFLT_hide_SSID);//////////////////////////////////////////////////////////////////
  WiFi.softAP(AP_ssid, AP_password,1,show_hide);//,hide_SSID);///////////////////////////////////////////////////////////////////////
  IPAddress myIP = WiFi.softAPIP();

  //statusLED.toggle_pix_led(ORANGE);

  Serial.print("AP IP ssid: ");
  Serial.println(AP_ssid);  
  Serial.print("AP IP pass: ");
  Serial.println(AP_password);
  Serial.print("AP IP address: ");
  Serial.println(myIP);
  /*///////////////////////////////////////////////////////////
  String nodeName = "arpschuino-" + WiFi.macAddress();
  nodeName.replace(":", "");
  char _nodeName[20]; nodeName.toCharArray(_nodeName, 20);
  WiFi.setHostname(_nodeName);
  ///////////////////////////////////////////////////////////*/
}

bool start_w_connection()
{
  WiFi.mode(WIFI_AP_STA);/////////////////////////////////////test////////////////////
  preferences.begin("wifi_datas", false);
  NWsetup("NW_ssid","NW_pass");
  delay(1);
  static const char * hostname = WiFi.getHostname();
  Serial.print("hostname : ");
  Serial.println(hostname);

  uint8_t val_NW_timeout =  preferences.getUChar("NW_timeout", DFLT_NW_timeout);
  Serial.print("Connection ");
  unsigned long previous_millis=millis();
  while(WiFi.status() != WL_CONNECTED)
  { 
    if(millis()-previous_millis>=val_NW_timeout*1000  || WiFi.status() == WL_NO_SSID_AVAIL )
    {
      previous_millis=millis(); 
      
      bool second_SSID = preferences.getBool("2SSID", DFLT_2SSID);
      if(second_SSID==true)
      {
        Serial.println("SSID unavailable,try second SSID");
        NWsetup("NW_ssid2","NW_pass2");
        WiFi._setStatus(WL_DISCONNECTED);
        delay(1);
        
        while(WiFi.status() != WL_CONNECTED )
        {
          if(millis()-previous_millis>=val_NW_timeout*1000 || WiFi.status() == WL_NO_SSID_AVAIL )//|| 
          {
            Serial.println("second SSID unavailable");
            WiFi.disconnect();//needed to be abble to execute wifi scan
            start_acces_point();
            return false;
          }
          Serial.print(".");
          delay(50);
        }
      }
      else
      {
          Serial.println("SSID unavailable");
          WiFi.disconnect();//needed to be abble to execute wifi scan
          start_acces_point();
          return false;          
      }
    }
    Serial.print(".");
    delay(50);
  }
  //Serial.print("WiFi status : ");Serial.println(WiFi.status());
  if(!MDNS.begin(hostname)) 
  {
     Serial.println("Error starting mDNS");
  }
  WiFi.setSleep(false);/////////////////////TEST!!!!!!!!!!!!!!!!///////////////////////////////////////////////////////////////
  Serial.println("\n");
  Serial.println("Connection established!");
  Serial.print("IP address : ");
  Serial.println(WiFi.localIP());
  return true;
}

void NWsetup(const char* ssid_num, const char* password_num)
{
  String str_ssid = preferences.getString(ssid_num, DFLT_NW_ssid2);
  Serial.print("SSID : ");Serial.println(str_ssid);
  const char* ssid = (str_ssid.c_str());
  String str_pass = preferences.getString(password_num, DFLT_NW_pass2);
  const char* password = str_pass.c_str();
  bool mode_static= preferences.getBool("mode_static", DFLT_mode_static);
  if(mode_static)
  {
    IPAddress ip,gateway,dns,subnet;
    ip.fromString(preferences.getString("fixIP", DFLT_fixIP));
    gateway.fromString(preferences.getString("fixGateway", DFLT_fixGateway));
    dns=gateway;
    subnet.fromString(preferences.getString("fixSubnet", DFLT_fixSubnet));
    WiFi.config(ip, dns, gateway, subnet);
  }
  String str_hostname = preferences.getString("hostname", DFLT_hostname); 
  const char* hostname = (str_hostname.c_str());
  WiFi.setHostname(hostname);

  delay(100);//was500//WAS 1000 !
  WiFi.begin(ssid, password);
}

bool check_network()
{
  static uint8_t attempt_to_reconnect = 0;
  if(attempt_to_reconnect==0)
  {
    Serial.println("scan start");
    int32_t temps = millis();
    int n = WiFi.scanNetworks();// return the number of networks found
    temps=millis()-temps;
    Serial.print("scan done in ");
    Serial.print(temps);
    Serial.println(" ms. ");
    if (n == 0) 
    {
        Serial.println("no networks found");
    } 
    else if (n == -2) 
    {
        Serial.println("wifi scan failed");
    }    
    else 
    {
      String str_ssid = preferences.getString("NW_ssid", DFLT_NW_ssid);
      Serial.print("search ");Serial.print(str_ssid);
      const char* ssid2 = DFLT_NW_ssid ;
      String str_ssid2;
      if(preferences.getBool("2SSID", DFLT_2SSID))
      {
        str_ssid2 = preferences.getString("NW_ssid2", DFLT_NW_ssid2);
        ssid2 = (str_ssid2.c_str()); 
        Serial.print(" or ");Serial.println(ssid2);
      } 
      Serial.print(n);
      Serial.println(" networks found :");
      for (int i = 0; i < n; ++i) 
      {
        // Print SSID and RSSI for each network found
        Serial.print(i + 1);
        Serial.print(": ");
        String foundSSID = WiFi.SSID(i);
        Serial.println(foundSSID);
        if(foundSSID == str_ssid || foundSSID == str_ssid2)
        {
          ESP.restart();
        }
      } 
    }
  }
  return 0;
}

//----------------------------------------------------------------------------------------------------------------------
// Function to update firmware incrementally
// Buffer is declared to be 128 so chunks of 128 bytes
// from firmware is written to device until server closes
bool updateFirmware(uint8_t *data, size_t len){
  Update.write(data, len);
  currentLength += len;
  // Print dots while waiting for update to finish
            static uint8_t dot=0;
            dot++;
            if(dot==0)  
              Serial.print('.');
  #ifdef PIXEL
    static uint8_t var=0;
    if(var==0)
    {
      statusLED.toggle_pix_led(WHITE);
      var=180;
    }
    var++;  
  #else               
    Arp_led_temoin (Arp_LED_BUILTIN);
  #endif
  // if current length of written firmware is not equal to total firmware size, repeat
  if(currentLength != totalLength) 
  {
    return 0;
  }
  Update.end(true);
  update_status="Success";
  Serial.printf("\nUpdate Success, Total Size: %u\n \n", currentLength);
  return 1;
}

bool checkupdate(String type){
  currentLength = 0;
  bool val_to_return=0;
  String prefix;
  // Connect to external web server
  if (type=="firmware")
  {
    update_status="checking firmware.";
    prefix= FWURL;
  }  
  else if (type=="filesystem")
  {
    update_status="checking filesystem.";
    prefix= SPIFFSURL;
  }  
  Serial.println(update_status);

  String VersionURL = prefix + new_version + ".bin";
  Serial.println(VersionURL); 
  client.begin(VersionURL);
  // Get file, just to check if each reachable
  int resp = client.GET();
  Serial.print("Response: ");
  Serial.println(resp);
  // If file is reachable, start downloading
  if(resp == 200){
    update_status=type+" version "+new_version+" available";
    Serial.println(update_status);
    //Serial.print("version ");Serial.print(new_version);Serial.println(" available");
      // get length of document (is -1 when Server sends no Content-Length header)
      totalLength = client.getSize();
      // transfer to local variable
      int len = totalLength;
      // this is required to start firmware update process
      if (type=="firmware")
        Update.begin(UPDATE_SIZE_UNKNOWN);
      else if (type=="filesystem")  
        Update.begin(UPDATE_SIZE_UNKNOWN, U_SPIFFS);
      Serial.print(type);
      Serial.printf(" Size: %u\n",totalLength);
      // create buffer for read
      uint8_t buff[128] = { 0 };
      // get tcp stream
      WiFiClient * stream = client.getStreamPtr();
      // read all data from server
      update_status="Updating "+type;
      Serial.println(update_status);

      while(client.connected() && (len > 0 || len == -1)) {
           // get available data size
           size_t size = stream->available();
           if(size) {
              // read up to 128 byte
              int c = stream->readBytes(buff, ((size > sizeof(buff)) ? sizeof(buff) : size));
              // pass to function
              val_to_return=updateFirmware(buff, c);

              if(len > 0) {
                 len -= c;
              }
           }
      }   
      if (type=="filesystem")
        update_status="update succes !";
  }
  else{
    update_status="Cannot download "+type+" file.";
    Serial.println(update_status);
    val_to_return=0;
  }
  client.end();
  Serial.println(update_status);
  return val_to_return;
}