#ifndef PORT_H
#define PORT_H

#include "global.h"

//#include <Arduino.h>
#include <Servo.h>
//#include "ARPStepper.h"
#include <vector>
#include "ArpAccelStepper.h"

class Port
{
public :
    
Port(char name);

void find_mode();
void debug();
void setNbDmxChannels(uint16_t nbChannels);//should auto adjust, except for pixel Led
uint16_t getNbDmxChannels()const;
uint16_t getMode()const;
String writeMode()const;


//record prototypes (overloaded)
void record(String name,uint8_t val,int num=255 )const ;
void record(String name,uint16_t val,int num=255 )const ;
void record(String name,uint32_t val,int num=255 )const ;
void record(String name,bool val,int num=255 )const ;
void record(String name,float val,int num=255 )const ;

// load methods (overloaded) il faut envoyer la valeur par défaut en argument.
uint8_t load(String name,uint8_t val,int num=255 )const ; 
uint16_t load(String name,uint16_t val,int num=255 )const ;
uint32_t load(String name,uint32_t val,int num=255 )const ;
bool load(String name,bool val,int num=255)const;
float load(String name,float val,int num=255 )const ;

void init();

void action(const std::vector<uint8_t> & DMXslice);

void runAtEachLoop();




protected:

//init methods
void PWM_setup();
void on_off_setup();
void servo_setup();
void stepper_setup();
//void stepper_setup2();
void CCmotor_setup();
void inputs_setup();///////////////////////////////////////////
void custom_setup();
//les méthodes action
void PWM_action(const std::vector<uint8_t> & DMXslice);
void on_off_action(const std::vector<uint8_t> & DMXslice)const;
void servo_action(const std::vector<uint8_t> & DMXslice);
void stepper_action(const std::vector<uint8_t> & DMXslice)const;
void CCmotor_action(const std::vector<uint8_t> & DMXslice)const;
void custom_action(const std::vector<uint8_t> & DMXslice)const;

void stpHome(uint8_t stpNum, uint8_t speed);
String format_key(String name, int num)const ;

char m_port_name;// ('A' ou 'B' ou 'W)

uint8_t m_nb_Pins;//ajout pour wilulu /////
uint16_t m_nbDmxChannels;
uint8_t m_startPin;
uint8_t m_mode;
bool m_dmxRes;

//PWM
uint8_t m_pwmRes;
uint8_t m_pwmCurve;
uint32_t m_pwmFreq;//calculé dans le setup
uint16_t m_actual_level[8];
uint16_t m_target_level[8];

//on/off
uint8_t m_trigger;//m_bascule renommé en m_trigger
bool m_inverted;

////servo
Servo *m_servo=NULL;//Déclaration d'un pointeur sur un objet de type Servo
bool m_servo_active[8];
uint16_t m_servoAngle[8];
bool m_servoInverted[8];
bool m_servoDetach[8];
uint8_t m_oldVal[8];//m_actual_level[8];

////stepper
ArpAccelStepper *m_stepper=NULL;//Déclaration d'un pointeur sur un objet de type ArpStepper
bool m_stp_active[4];
bool m_action[4];
bool m_stp_dmxRes[4];//true : _16bits, false : _8bits
uint64_t m_endPosition[4];
bool m_stpZeroSW[4];
bool m_stpEndSW[4];
uint8_t m_stpzero_input[4];
uint8_t m_stpend_input[4];
//bool m_stpZeroSWstate[4];
//bool m_stpEndSWstate[4];
//bool m_homing[4];

////CCmotor
uint8_t m_stp_driver_type;//for all the port???????????????????????????????????
bool m_CC_active[4];
uint8_t m_CC_driver_type[4];
bool m_CC_inverted[4];
uint8_t m_cc_threshold[4];
uint16_t m_CC_freq[4];//////////////////////////////
bool m_CCZeroSW[4];
bool m_CCEndSW[4];
uint8_t m_CCzero_input[4];
uint8_t m_CCend_input[4];

///////////////////////////////////////// interruptions ////////////////////////////////
// static void IRAM_ATTR fonction_ISR();
// static void IRAM_ATTR fonction_ISR2();
};

#endif 