#pragma once
#include <Arduino.h>
#include <Adafruit_PWMServoDriver.h>
#include <vector>
#include <string>


class Device
{
     public :
          
     Device();             //constructor
     Device(uint8_t ID);   //constructor
     Device(uint8_t ID, uint8_t address);   //constructor
     ~Device();            //destructor

     void set_ID(uint8_t ID);
     void set_address(uint8_t address);
     void setNbDmxChannels(uint8_t nb_ch);

     String get_type() const;
     uint8_t get_address() const;
     uint16_t getNbDmxChannels() const;

////////////////////  statics methodes  ///////////////////////////
     static void create_devices();
     static void delete_devices(uint8_t ID);
     static void init();     
     static uint8_t get_nb_devices();
     static String scan();

////////////////////  virtuals methodes  ///////////////////////////
     virtual void affiche() const;
     virtual void setup();
     virtual void action(const std::vector<uint8_t> & DMXslice);
     virtual void runAtEachLoop();
     

     protected:

     uint8_t _ID;
     String _type;
     uint8_t _address;
     uint16_t _nbDmxChannels;
////////////////////  static  ///////////////////////////     
     static uint8_t _nb_devices;
};

/////////////////////////////////// children /////////////////////////////////

class Tinylulu : public Device
{
     public :

    Tinylulu(uint8_t ID);   //constructor
    Tinylulu(uint8_t ID, uint8_t address); 

    virtual void setup();
    virtual void action(const std::vector<uint8_t> & DMXslice);
    virtual void runAtEachLoop();

     protected:

     uint8_t _actual_level;
     uint8_t _must_send;     

};

class Twinylulu : public Device
{
     public :

     Twinylulu(uint8_t ID);   //constructor
     Twinylulu(uint8_t ID, uint8_t address); 

     virtual void setup();
     virtual void action(const std::vector<uint8_t> & DMXslice);
     virtual void runAtEachLoop();

     protected:

     uint8_t _actual_level[2];
     uint8_t _must_send; 

};

class Arpsensors : public Device
{
     public :

     Arpsensors(uint8_t ID);   //constructor
     Arpsensors(uint8_t ID, uint8_t address); 

     virtual void setup();
     virtual void action(const std::vector<uint8_t> & DMXslice);
     virtual void runAtEachLoop();


     protected:

     uint8_t _actual_level[9];
     uint8_t _must_send;
};

class Spider_board : public Device
{
     public :

    Spider_board(uint8_t ID);   //constructor
    Spider_board(uint8_t ID, uint8_t address);   //constructor

    virtual void setup();
    virtual void action(const std::vector<uint8_t> & DMXslice);

     protected:

     Adafruit_PWMServoDriver _spider;//1 = Adafruit_PWMServoDriver(0x40);//dip 000000
     uint16_t _actual_level[16];
     uint16_t _target_level[16];
};

class Custom : public Device
{
     public :

    Custom(uint8_t ID);   //constructor
    Custom(uint8_t ID, uint8_t address); 

    virtual void setup();
    virtual void action(const std::vector<uint8_t> & DMXslice);
    virtual void runAtEachLoop();

     protected:

};