#include "I2C_port.h"
#include <Preferences.h>
#include <Wire.h>
#include "Custom_port.h"

using namespace std;

vector<Device*>I2C_port ;
uint8_t Device::_nb_devices = 0;

extern Preferences preferences;

    Device::Device() : _ID (255)
    {
           
    }

    Device::Device(uint8_t ID) :  _ID (ID)
    {

    } 

    Device::Device(uint8_t ID, uint8_t address) :  _ID (ID), _address (address)
    {

    }

    Device::~Device()
    {

    }

    void Device::set_ID(uint8_t ID)
    {
        _ID = ID;
    }

    void Device::set_address(uint8_t address)
    {
        _address = address;
    }

    void Device::setNbDmxChannels(uint8_t nb_ch)
    {
        _nbDmxChannels = nb_ch;
    }
    
    String Device::get_type() const
    {
        return _type;
    }

    uint8_t Device::get_address() const
    {
        return _address;
    }

    void  Device::affiche() const
    {
        Serial.print("device ");
        Serial.print(_ID);
        Serial.print(" ");
        Serial.print(_type);
        Serial.print(", I2C address : 0x");
        Serial.print(_address, HEX);
        Serial.print(" (");
        Serial.print(_address);
        Serial.println(")");
    } 

    void Device::setup()
    {
        Serial.println("Generic device : nothing to do...");
        _nbDmxChannels = 0;
    } 

    void Device::action(const std::vector<uint8_t> & DMXslice)
    {

    }

    void Device::runAtEachLoop()
    {

    } 

    uint16_t Device::getNbDmxChannels() const
    {
        return _nbDmxChannels;
    }
/////////////////////////////////// static methodes /////////////////////////////////

    void Device::create_devices()
    {
        _nb_devices = preferences.getUChar("nb_devices", 0);//get the number of i2c devices   (in eeprom)               
        Serial.print("Port I2C : ");Serial.print(_nb_devices);Serial.println(" device(s):");

        for(uint8_t i=0;i<_nb_devices;i++)
        { 
            String type_of_device;
            uint8_t address;

            String str_i(i);
            String str =str_i + "I2Cdevice"; 
            const char *key = str.c_str();
            type_of_device = preferences.getString(key, "generic");// get type of device

            str =str_i + "I2Caddress"; 
            key = str.c_str();
            address = preferences.getUChar(key, 254);// get device i2c address

            if(type_of_device == "tinylulu")
            {
                I2C_port.push_back(new Tinylulu(i));
            }
            else if(type_of_device == "twinylulu")
            {
                I2C_port.push_back(new Twinylulu(i));
            }
            else if(type_of_device == "arpsensors")
            {
                I2C_port.push_back(new Arpsensors(i)); 
            } 
            else if(type_of_device == "spider board")
            {
                I2C_port.push_back(new Spider_board(i,address));
            }                        
            else
            {
                I2C_port.push_back(new Device(i));
            }
            I2C_port[i]->set_address(address);
            I2C_port[i]->affiche();                        
        } 
        Serial.println();
    }

    void Device::delete_devices(uint8_t ID)
    {
        bool deleted;
        String type_of_device;
        uint8_t address;

        _nb_devices = preferences.getUChar("nb_devices", 0);//get the number of i2c devices                  
        for(int i=ID;i<_nb_devices-1;i++)
        {
            String str_i(i);
            String str =str_i + "I2Cdeleted"; 
            const char *key = str.c_str();
            preferences.putBool(key, false);//set the curent as not deleted 

            uint8_t n = i+1;
            String next_i(n);                  
            String next = next_i + "I2Cdevice"; 
            const char *next_key = next.c_str();
            type_of_device = preferences.getString(next_key, "generic");//get the next type

            str =str_i + "I2Cdevice"; 
            key = str.c_str();
            preferences.putString(key, type_of_device);// set type of device
            Serial.print("put ");Serial.print(n);Serial.print(" devices in ");Serial.println(i);

            next = next_i + "I2Caddress";
            next_key = next.c_str();
            address = preferences.getUChar(next_key, 255);// get device i2c address

            str =str_i + "I2Caddress"; 
            key = str.c_str();
            preferences.putUChar(key, address);//set address
            Serial.print("put ");Serial.print(n);Serial.print(" address in ");Serial.println(i);                   
        }
        _nb_devices --;
        preferences.putUChar("nb_devices", _nb_devices);//decremente the number of i2c devices 
        Serial.print("new nb devices : ");Serial.println(_nb_devices);
    }

    void Device::init()
    {
        create_devices();
        if(_nb_devices>0)
        {
            //#define I2C_SDA 2
            //#define I2C_SCL 4
            Wire.begin(Arp_SDA, Arp_SCL);

            for(int i=0;i<_nb_devices;i++)
            {
                I2C_port[i]->setup();
            }
        }
    }

    uint8_t Device::get_nb_devices()
    {
        return _nb_devices;
    } 


    String Device::scan()
    {
        String response="";;
        byte error, address;
        int nDevices;
        Serial.println("Scanning...");
        nDevices = 0;
        for(address = 1; address < 127; address++ ) 
        {
            Wire.beginTransmission(address);
            error = Wire.endTransmission();
            if (error == 0) 
            {
                response += "I2C device found at address 0x";
                Serial.print("I2C device found at address 0x");
                if (address<16) {
                    response += "0";
                    Serial.print("0");
                }
                response += String(address,HEX);
                response += " (";
                response += address;
                response += ")";                
                response += "<br>";
                Serial.print(address,HEX);
                Serial.print(" (");
                Serial.print(address);
                Serial.println(")");
                nDevices++;
            }
            else if (error==4) {
            Serial.print("Unknow error at address 0x");
            if (address<16) {
                Serial.print("0");
            }
            Serial.println(address,HEX);
            }    
        }
        if (nDevices == 0) {
            response += "No I2C devices found";
            Serial.println("No I2C devices found\n");
        }
        else {
            Serial.println("done\n");
        }
        
        return response;
    }
/////////////////////////////////// children /////////////////////////////////

    Tinylulu::Tinylulu(uint8_t ID) : Device(ID)    
    {
        _type="tinylulu";
    }     
    Tinylulu::Tinylulu(uint8_t ID, uint8_t address) : Device(ID, address) 
    {
        _type="tinylulu";
    }     

    void Tinylulu::setup()
    {
        Serial.println("tinylulu setup");
        _nbDmxChannels = 1;
        _actual_level = 0;
    } 

    void Tinylulu::action(const std::vector<uint8_t> & DMXslice)
    {
        if(DMXslice[0]!=_actual_level)
        {
            _actual_level = DMXslice[0];// Serial.println(_actual_level);
            _must_send = true;  
        }

    }

    void Tinylulu::runAtEachLoop()
    {
       if(_must_send) 
       {
            Wire.beginTransmission(_address);      // déclare l'adresse de l'esclave qui va recevoir le code
            Wire.write(_actual_level);//_target_level);                        // envoie la donnée
            Wire.endTransmission();                  // arrête la transmission
            _must_send=false;         
       }  
    } 

/////////////////////////////
    Twinylulu::Twinylulu(uint8_t ID) : Device(ID)    
    {
        _type="twinylulu";
    }
    Twinylulu::Twinylulu(uint8_t ID, uint8_t address) : Device(ID, address) 
    {
        _type="twinylulu";      
    }    

    void Twinylulu::setup()
    {

        Serial.println("twinylulu setup");
        _nbDmxChannels = 2;
        _actual_level[0] = 0;
        _actual_level[1] = 0;    
    } 

    void Twinylulu::action(const std::vector<uint8_t> & DMXslice)
    {
        for(int i=0;i<_nbDmxChannels;i++)
        {
            if(DMXslice[i]!=_actual_level[i])
            {
                _actual_level[i] = DMXslice[i];
                _must_send = true;  
            }
        }  
    }

    void Twinylulu::runAtEachLoop()
    {
       if(_must_send) 
       {
            Wire.beginTransmission(_address);      // déclare l'adresse de l'esclave qui va recevoir le code
            Wire.write(_actual_level[0]);//_target_level);                        // envoie la donnée
            Wire.write(_actual_level[1]);//_target_level);                        // envoie la donnée
            Wire.endTransmission();                  // stop transmission

            _must_send=false;         
       }  
    } 
/////////////////////////////
    Arpsensors::Arpsensors(uint8_t ID) : Device(ID)
    {
        _type="arpsensors";
    }       
    Arpsensors::Arpsensors(uint8_t ID, uint8_t address) : Device(ID, address)
    {
        _type="arpsensors";
    }     

    void Arpsensors::setup()
    {
        Serial.println("arpsensors setup");
        _nbDmxChannels = 9;
        for(int i=0;i<_nbDmxChannels;i++)
        {
            _actual_level[i] = 0;
        }
    } 

    void Arpsensors::action(const std::vector<uint8_t> & DMXslice)
    {
        for(int i=0;i<9;i++)
        {
            if(DMXslice[i]!=_actual_level[i])
            {
                _actual_level[i] = DMXslice[i];
                _must_send = true;  
            }
        }
    }

    void Arpsensors::runAtEachLoop()
    {
       if(_must_send) 
       {
            Wire.beginTransmission(_address);      // déclare l'adresse de l'esclave qui va recevoir le code
            for(int i=0;i<9;i++)
            {                                    // envoie la donnée
                Wire.write(_actual_level[i]);//_target_level);                        // envoie la donnée     
            }
            Wire.endTransmission();                  // arrête la transmission
            _must_send=false;         
       }  
    } 
/////////////////////////////
    Spider_board::Spider_board(uint8_t ID) : Device(ID),_spider(0x40, Wire)
    {
        _type="spider_board";
    }     
    Spider_board::Spider_board(uint8_t ID, uint8_t address) : Device(ID, address), _spider(_address, Wire)
    {
        _type="spider_board";
        Adafruit_PWMServoDriver _spider = Adafruit_PWMServoDriver(_address);
    }     

    void Spider_board::setup()
    {
        Serial.println("Spider_board : create PWMServoDriver object");
        _spider.begin();
        _spider.setPWMFreq(1600);
        _nbDmxChannels=16;
        for(int i=0;i<_nbDmxChannels;i++)
        {
            _actual_level[i] = 0;
        }        
    } 

    void Spider_board::action(const std::vector<uint8_t> & DMXslice)
    {
        for (int i=0; i < 16; ++i) 
        {
            if(DMXslice[i] != _actual_level[i])
            {
                _actual_level[i] = DMXslice[i];
                _target_level[i] = (((DMXslice[i]+1)*(DMXslice[i]+1)-1)>>4);
                _spider.setPWM(i, 0, _target_level[i]);//courbe led
            }          
        }
    }
    //////////////////////////////////////////////////////////////////////////////////////

    Custom::Custom(uint8_t ID) : Device(ID)    
    {
        _type="custom";
    }     
    Custom::Custom(uint8_t ID, uint8_t address) : Device(ID, address) 
    {
        _type="custom";
    }     
 
    void Custom::setup()
    {
        Serial.println("Custom setup");
        setupI2C(_ID);
    } 

    void Custom::action(const std::vector<uint8_t> & DMXslice)
    {
        actionI2C(_ID,DMXslice);
    }

    void Custom::runAtEachLoop()
    {
        at_each_loop_I2C(_ID);
    } 