//#include "global.h"

#include "custom_port.h"
#include <arduino.h>
//#include <arpschuino32_core.h>
#include <arpschuino.h>
#include "port.h"
#include "I2C_port.h"
#include <vector>
using namespace std;


//put here the library you want to use

#ifdef WILULU32
  extern Port portW;
#endif
extern Port portA;
#ifdef ARPSCHUINO32
  extern Port portB;
#endif
extern vector<Device*>I2C_port ;


#ifdef WILULU32
//////////// port W (wilulu out) ////////////// 
const uint8_t button = Arp[0];//PIN for the button to select DMX or potentiometer
const uint8_t pot = Arp[1];//PIN for the potentiometer
uint16_t actual_level;
uint16_t target_level;


void setupW()//this loop is executed once at startup
{
  portW.setNbDmxChannels(1);//the number of channels used in this port. REQUIRED !
  ledcSetup(8, 2441, 15); // configure LED PWM functionalitites
  ledcAttachPin(WiluluOUT_0, 8);     // attach the channel to the GPIO to be controlled 

  pinMode(button, INPUT_PULLUP);
  pinMode(pot, INPUT);
} 
void action_W(const std::vector<uint8_t> & DMXslice)  //this loop is executed at each signal reception
{
  if(digitalRead(button))
  {
    target_level = (((DMXslice[0] + 1) * (DMXslice[0] + 1) - 1) >> 1); // level = (((DMXslice[i]+1)*(DMXslice[i]+1)-1)>>(16-m_pwmRes));
  }
  else
  {
    uint16_t temp = analogRead(pot);
    target_level = (((temp + 1) * (temp + 1) - 1) >> 9); // temp should be a 12 bits value
    // or :  target_level = analogRead(pot)<<3;//no curve
  }
}
void at_each_loop_W() 
{
    int32_t level;
    if (actual_level < target_level)
    {
        level = actual_level + 1 + (actual_level / 256); // m_actual_level[i]++;
        if (level > target_level)
            actual_level = target_level;
        else
            actual_level = level;
        ledcWrite(8, actual_level);
    }
    else if (actual_level > target_level)
    {
        level = actual_level - 1 - (actual_level / 256); // m_actual_level[i]--;
        if (level < target_level)
            actual_level = target_level;
        else
            actual_level = level;
        ledcWrite(8, actual_level);
    }
}
#endif


//////////// port A //////////////
#include <ArpAccelStepper.h>

ArpAccelStepper stepper(ArpAccelStepper::DRIVER, 22, 21);

void setupA()   //this loop is executed once at startup
{   
  portA.setNbDmxChannels(4);
  stepper.setMinPulseWidth(7);
  stepper.setMaxSpeed(10000.0);
  stepper.setAcceleration(4000.0);
  //stepper.moveTo(32000);//20 tours à 1600 stp/tour
}

void action_A(const std::vector<uint8_t> & DMXslice)  //this loop is executed at each signal reception
{
  //stepper.moveTo(map(DMXslice[0],0,255,0,32000));
  //stepper.move(10000);
  stepper.setSpeed(DMXslice[0]*20);

}

void at_each_loop_A()   //this loop is executed continuously
{
  stepper.runSpeed();
  //stepper.setSpeed(10000);
}


#ifdef ARPSCHUINO32
//////////// port B //////////////
//1 CC motor with end switchs

int motorPin1 = Arp8;
int motorPin2 = Arp9;
int endSwitch0=Arp12; 
int endSwitch1=Arp13;
 

void setupB()      //this loop is executed once at startup
{
  // Pont en H L298N
  pinMode(motorPin1, OUTPUT);
  pinMode(motorPin2, OUTPUT);
  pinMode(endSwitch0, INPUT_PULLUP);//see : https://roboticsbackend.com/arduino-input_pullup-pinmode/
  pinMode(endSwitch1, INPUT_PULLUP);   

  ledcSetup(8,25000,8);//channel, freq, Resolution,25000Hz should be unaudible
  ledcAttachPin(Arp8,8);// attach the channel to the GPIO to be controlled
  ledcSetup(9,25000,8);
  ledcAttachPin(Arp9,9); 

  portB.setNbDmxChannels(4);//2???//the number of channels used in this port. REQUIRED !
  Serial.println(": custom, setup done");
  Serial.println("1 CC motor with end switchs");
}

void action_B(const std::vector<uint8_t> & DMXslice)    //this loop is executed at each signal reception
{  
  uint8_t state = DMXslice[0];
  bool direction = (state > 127) ? 0 : 1;
  uint8_t speed = DMXslice[1];

  if (speed>0)
  {
    if (direction && digitalRead(endSwitch0)) // avant//forward
    {
      ledcWrite(8, speed); 
      ledcWrite(9, 0);
    }
    else if(not direction && digitalRead(endSwitch1))// arrière//backward
    {
      ledcWrite(8, 0);
      ledcWrite(9, speed); 
    }
    else 
    {
      ledcWrite(8, 0); 
      ledcWrite(9, 0);
    }       
  }
  else // Stop (freinage)//Break
  {
    ledcWrite(8, 0); 
    ledcWrite(9, 0);
  }       
}

void at_each_loop_B()   //this loop is executed continuously
{
   // nothing to do !....
}
#endif
//////////// port I2C //////////////


void setupI2C(uint8_t ID )   //this loop is executed once at startup
{
  setup();
    switch(ID)
    {
      case 0 : {
        I2C_port[ID]->setNbDmxChannels(8);//the number of channels used by this device. REQUIRED !
        //put your setup for ID0 device here
          break;
      }
      case 1 : {
        I2C_port[ID]->setNbDmxChannels(8);//the number of channels used by this device. REQUIRED !
        //put your setup for ID1 device here          
          break;
      } 
      case 2 : {
        I2C_port[ID]->setNbDmxChannels(8);//the number of channels used by this device. REQUIRED !
        //put your setup for ID0 device here          
          break;
      } 
      //etc, 6 devices max
    }                   
}

void actionI2C(uint8_t ID,const std::vector<uint8_t> & DMXslice)  //this loop is executed at each signal reception
{
  switch(ID)
  {
    case 0 : {//ID0 device
      
      break;
    }
    case 1 : {//ID1 device
      
      break;
    } 
    case 2 : {//ID2 device
      
      break;
    } 
  } 
}

void at_each_loop_I2C(uint8_t ID)   //this loop is executed continuously
{
  switch(ID)
  {
    case 0 : {//ID0 device
      
      break;
    }
    case 1 : {//ID1 device
      
      break;
    } 
    case 2 : {//ID2 device
      
      break;
    }
  }  
}