
#include "Arpschuino.h"

#if defined(__AVR__)
  #include <avr/io.h>
  #include <util/crc16.h>
  #include <avr/eeprom.h>
  #include <avr/sleep.h>
#endif
#if ARDUINO >= 100
  #include <Arduino.h> // Arduino 1.0
#else
  #include <WProgram.h> // Arduino 0022
#endif

#define ARPDRESS_BOARD 0x26

#include <EEPROM.h>
int EEPROMaddr = 0;

#if defined(ARPSCHUINO) || defined(JEENODE_JEELINK)
  #define voyant     LED_BUILTIN
  #include <Wire.h>   

#elif defined(WILULU)
  #define voyant     LED_BUILTIN     
  
#elif defined (ARPSENSORS) || defined(ARPSENSORSRF)
  #define voyant     0

#elif defined(ESP32)
  //#include "global.h"
  #ifdef ARPSCHUINO32
    #include <arpschuino32_core.h>
    //#define Arp_SDA 2 //sda
    //#define Arp_SCL 4 //scl
  #endif
  #ifdef WILULU32
    #include <wilulu32_core.h>
    #define Arp_SDA 16 //sda
    #define Arp_SCL 4 //scl
  #endif

  #define EEPROM_SIZE 512
  static const uint8_t  voyant  =  0;
  #include <Wire.h>
#endif

#define voyant() Arp_led_temoin ()// backward compatibility
//__________________________________________________________ 
//                                                          |
//                       led_temoin                         |
//__________________________________________________________|

bool var_led=0;
uint16_t var_led_level;

bool Arp_led_temoin ()
{
  digitalWrite (voyant,var_led);
  var_led = var_led-1;
  return (var_led);
}

bool Arp_led_temoin (int pin)
{
  digitalWrite (pin,var_led);
  var_led = var_led-1;
  return (var_led);
}
#if defined(ESP32)
  uint16_t Arp_led_temoin (uint8_t PWMchannel, uint16_t level)
  {
    var_led_level = (var_led_level>0) ? 0 : level;

    ledcWrite(PWMchannel, var_led_level);
    return (var_led_level);
  }


  // uint16_t Arp_led_temoin (uint8_t PWMchannel, uint16_t level,uint32_t color)
  // {
  //   var_led_level = (var_led_level>0) ? 0 : level;

  //   //ledcWrite(PWMchannel, var_led_level);
  //   return (var_led_level);
  // }  
#endif


  #if defined(ARPSCHUINO)||defined(ESP32)

//__________________________________________________________
//                                                          |
//             adressage avec l'arpdress board              |
//__________________________________________________________|

//29/06/18 delay racourcis
//lecture prealable de l'eeprom
//adresse 1 si l'eeprom est vierge
 
extern int adress;//debug 26/12/16 pour les adresses au dela de 255...
//extern int nbre_circuits;//passe ds le.h

int Arp_arpdress_board()
{
  #if defined(ESP32)
    TwoWire Wire(0);
    // if (!EEPROM.begin(EEPROM_SIZE))
    // {
    //   Serial.println("failed to initialise EEPROM");
    // }
  #endif
  int address_read=0;
  //byte unite = 0;
  //byte disaine = 0;
  //byte centaine = 0;

  ////////////////lecture préalable de l'eeprom//////////////
 
  int previous_address =Arp_read_dmx_address(); 

  ///////////////presence de l'arpdress-board ? /////////////////////////
  boolean arpdress = true;//variable pour indiquer la presence (ou non) de l'arpdress board
  #if defined (ARPSENSORS) || defined(ARPSENSORSRF) 
    if ((digitalRead (18) == HIGH) && (digitalRead (19) == HIGH)){
  #elif defined(ESP32)
    if ((digitalRead (SDA) == HIGH) && (digitalRead (SCL) == HIGH)){
      Serial.println("something detected on i2c port !");
  #endif

    char arpdress_code[8] = {'a','r','p','d','r','e','s','s'};
    #if defined(ESP32)  
      Wire.begin(SDA,SCL); 
    #else
     Wire.begin();
    #endif
    Wire.beginTransmission(ARPDRESS_BOARD);      // declare l'adresse de l'esclave qui va recevoir le code
    Wire.write(0xB);                        // envoie la donnee
    Wire.endTransmission();                  // arrete la transmission
        
       
    delay (250);
    
    Wire.requestFrom(ARPDRESS_BOARD, 8);     // request 8 bytes from slave
    
    if (Wire.available()) 
    {     
        char reponse[8] = {0};
        delay(200);
        for(int i=0; i<8; i++){
          reponse[i] = Wire.read();
        delay(10);
        }
        delay(100);
        for(int i=0;i<8;i++) {
           if (arpdress_code[i]!=reponse[i])
           {
            arpdress = false;
           }
        }
     }    
      else {
        arpdress = false;
      }
   } 
   else {
     arpdress = false;
     #if defined(ESP32)
      Serial.println("nothing detected on i2c port !");
     #endif     
   }
   /////////////////////////////////////////////////////////////////////////// 
    if (arpdress == true)
    {//si l'arpdress-board est branche et le port bas debranche
       #if defined(ESP32)
        Serial.println("arpdress board is responding ");
       #endif 
  /////////////////////////I2C///////////////////////////////////////////
  //////envoie requete///////

      Wire.beginTransmission(ARPDRESS_BOARD);      // declare l'adresse de l'esclave qui va recevoir le code
      Wire.write(0xDE);                        // envoie la donnee
      Wire.endTransmission();                  // arrete la transmission
      delay (250);
         
      //////////Lecture de l'arpdress board, on attend 3 byte//////////////////////////////////////////
  
      Wire.requestFrom(ARPDRESS_BOARD, 3);     // request 3 bytes from slave
                              delay(200);
      if (Wire.available()) 
      {
    
         byte unite_read = Wire.read();
                                                           
         byte disaine_read = Wire.read();
                                                                 
         byte centaine_read = Wire.read();
                                      
         address_read =(centaine_read*100)+(disaine_read*10)+(unite_read);
       
         adress = address_read;
      }
      else
      {
        adress = previous_address;
      }
      
      if (Arp_write_dmx_address())
      {
        digitalWrite(LED_BUILTIN,LOW);
        delay (500);
        digitalWrite(LED_BUILTIN,HIGH);       
      }
      else
      {
         adress=previous_address;
         for (int i=0;i<10;i++)
         {
            digitalWrite(voyant,LOW);//bitWrite (PORTD,4,0);     //MOD ESP
            delay (250);//divisé par 2, a tester
            digitalWrite(voyant,HIGH);//bitWrite (PORTD,4,1);//MOD ESP
            delay (250);//divisé par 2, a tester
         } 
      }
     #if defined(ESP32)
      Serial.println("DMX address is now : ");
      Serial.println(address);
     #endif           
    }
  ////////////////////si l'apdress board n'est pas présente/////////// 
    else
    {
       #if defined(ESP32)
        Serial.print("arpdress board is not responding, keep previous address : ");
        Serial.println(previous_address);
       #endif       

       adress = previous_address;
       digitalWrite(voyant,LOW);//bitWrite (PORTD,4,0);     //MOD ESP
       delay (100);
       digitalWrite(voyant,HIGH);//bitWrite (PORTD,4,1);//MOD ESP
       delay (100);
       digitalWrite(voyant,LOW);//bitWrite (PORTD,4,0);//MOD ESP
       delay (100);
       digitalWrite(voyant,HIGH);//bitWrite (PORTD,4,1);//MOD ESP
    }          
      ///////////////////////////////////////////////////
      //////////////////////////////////////////////////
      ////////////////////////////////////////////

    int debordement = adress+nbre_circuits-513;//anti debordement debug 29/10/2017

    if(debordement>0)
    {
      nbre_circuits = nbre_circuits-debordement;
    }
    //Serial.println(nbre_circuits);//debug
    delay(500);

    #if defined(ARPSCHUINO) || defined(JEENODE_JEELINK)
      Wire.end();  
      pinMode(18, OUTPUT);
      pinMode(19, OUTPUT);
    #elif defined(ESP32)
      pinMode(SDA, OUTPUT);
      pinMode(SCL, OUTPUT);
    #endif

    return (address_read);
}
//__________________________________________________________
//                                                          |
//             lecture de l'adresse                        |
//__________________________________________________________|
unsigned int Arp_read_arpdress_board(uint8_t sda,uint8_t scl)
{
  #if defined(ESP32)
    TwoWire Wire(0);
  #endif
  int address_read=0;

  ///////////////presence de l'arpdress-board ? /////////////////////////
  boolean arpdress = true;//variable pour indiquer la presence (ou non) de l'arpdress board
  #if defined (ARPSENSORS) || defined(ARPSENSORSRF) 
    if ((digitalRead (18) == HIGH) && (digitalRead (19) == HIGH)){
  #elif defined(ESP32)
    if ((digitalRead (sda) == HIGH) && (digitalRead (scl) == HIGH)){
      Serial.println("something detected on i2c port !");
  #endif

    char arpdress_code[8] = {'a','r','p','d','r','e','s','s'};  
    #if defined(ESP32)  
      Wire.begin(sda,scl); 
    #else
      Wire.begin();
    #endif
    Wire.beginTransmission(ARPDRESS_BOARD);      // declare l'adresse de l'esclave qui va recevoir le code
    Wire.write(0xB);                        // envoie la donnee
    Wire.endTransmission();                  // arrete la transmission
        
       
    delay (200);//was 250
    
    Wire.requestFrom(ARPDRESS_BOARD, 8);     // request 8 bytes from slave
    
    if (Wire.available()) 
    {     
      char reponse[8] = {0};
      delay(200);
      for(int i=0; i<8; i++){
        reponse[i] = Wire.read();
      delay(10);
      }
      delay(100);
      for(int i=0;i<8;i++) {
          if (arpdress_code[i]!=reponse[i])
          {
          arpdress = false;
          }
      }
    }    
    else 
    {
      arpdress = false;
    }
   } 
   else 
   {
     arpdress = false;
     #if defined(ESP32)
      Serial.println("nothing detected on i2c port !");
      address_read=1000;//astuce pour indiquer que l'arpdress n'a pas été détecté !
      
     #endif     
   }
   /////////////////////////////////////////////////////////////////////////// 
  if (arpdress == true)
  {//si l'arpdress-board est branche et le port bas debranche
      #if defined(ESP32)
      Serial.println("arpdress board is responding ");
      #endif 
  /////////////////////////I2C///////////////////////////////////////////
  //////envoie requete///////

    Wire.beginTransmission(ARPDRESS_BOARD);      // declare l'adresse de l'esclave qui va recevoir le code
    Wire.write(0xDE);                        // envoie la donnee
    Wire.endTransmission();                  // arrete la transmission
    delay (250);
        
    //////////Lecture de l'arpdress board, on attend 3 byte//////////////////////////////////////////

    Wire.requestFrom(ARPDRESS_BOARD, 3);     // request 3 bytes from slave
                            delay(200);
    if (Wire.available()) {
  
        byte unite_read = Wire.read();
                                                          
        byte disaine_read = Wire.read();
                                                                
        byte centaine_read = Wire.read();
                                    
        address_read =(centaine_read*100)+(disaine_read*10)+(unite_read);
      

      digitalWrite(LED_BUILTIN,LOW);
      delay (500);
      digitalWrite(LED_BUILTIN,HIGH);       

    }
  }

  #if defined(ARPSCHUINO) || defined(JEENODE_JEELINK)
    Wire.end();  
    pinMode(18, OUTPUT);
    pinMode(19, OUTPUT);
  #elif defined(ESP32)
    Wire.end(); 
    pinMode(sda, OUTPUT);//utile ou pas?
    pinMode(scl, OUTPUT);
  #endif

  return (address_read);
}

//__________________________________________________________
//                                                          |
//             ecriture de l'adresse                        |
//__________________________________________________________|


bool Arp_write_dmx_address()
{
  bool  test = 0;
  if(address<513 && address>0){
   uint8_t cent = address/100;
   uint8_t dis = (address%100)/10;
   uint8_t unit = address%10;   
//////////////////////////////EEPROM/////////////////////////////////
   #if defined(ESP32)
    EEPROM.begin(EEPROM_SIZE);
   #endif 
   EEPROM.write(EEPROMaddr, cent);       //centaines
   EEPROM.write(EEPROMaddr+1, dis); //disaines
   EEPROM.write(EEPROMaddr+2, unit);      //unites
   #if defined(ESP32)
    EEPROM.commit();
   #endif
   test = 1;
  }
  else test = 0;
  return test;
}

//__________________________________________________________
//                                                          |
//             lecture de l'adresse                         |
//__________________________________________________________|

int Arp_read_dmx_address()
{
   #if defined(ESP32)
    EEPROM.begin(EEPROM_SIZE);
   #endif
   bool test = 0;
   uint8_t cent = EEPROM.read(EEPROMaddr);
   if(cent>5) test=1;
   uint8_t dis = EEPROM.read(EEPROMaddr+1);
   if(dis>9) test=1;
   uint8_t unit = EEPROM.read(EEPROMaddr+2);
   if(unit>9) test=1;
   uint16_t readed_address =(cent*100)+(dis*10)+(unit);
   if(readed_address==0||readed_address>512||test==1) readed_address=1;
   return readed_address;
}
 
 //__________________________________________________________
//                                                          |
//             ecriture des valeurs par defaut              |
//__________________________________________________________|
 
void Arp_default_EEPROM() 
{
    #if defined(ARPSCHUINO) || defined(JEENODE_JEELINK)
      EEPROM.update(0x0,0);//centaines
      EEPROM.update(0x1,0);//disaines
      EEPROM.update(0x2,1);//unites
      
      EEPROM.update(0x3,0);//mode
    #elif defined(ESP32)
      EEPROM.begin(512);
      EEPROM.write(0x0,0);//centaines
      EEPROM.write(0x1,0);//disaines
      EEPROM.write(0x2,1);//unites
      
      EEPROM.write(0x3,0);//mode
    #endif      

  EEPROM.put(0x4,16);//nombre de circuit
  #if defined(ESP32)
    EEPROM.commit();
    Serial.println(F("EEPROM set at default values :"));
    Serial.print(F("address : 001; mode : 0; 16 channels"));
  #endif  
}
  #endif
