

#include "ArpAccelStepper.h"

#if 0
// Some debugging assistance
void dump(uint8_t* p, int l)
{
    int i;

    for (i = 0; i < l; i++)
    {
	Serial.print(p[i], HEX);
	Serial.print(" ");
    }
    Serial.println("");
}
#endif

////////////////constructors ////////////////////////////
ArpAccelStepper::ArpAccelStepper(uint8_t interface, uint8_t pin1, uint8_t pin2, uint8_t pin3, uint8_t pin4, bool enable)
{
    ///////////////////////from ArpStepper//////////////////
    _inverted=false;
    _step_per_revolution=400;//step per revolution;//nombre de pas par tour
    _revolutions=10;//number of revolutions desired (in float to have decimal numbers)
                      //nombre de tours souhaite(en float pour avoir les nombres a virgule)
    //m_AccelStepper(1),//1 mean Driver mode
    _resolution=255; //the resolution of the command in bits
    ///////////////////////from AccelStepper//////////////////
    _interface = interface;
    _currentPos = 0;
    _targetPos = 0;
    _speed = 0.0;
    _maxSpeed = 0.0;
    _acceleration = 0.0;
    _sqrt_twoa = 1.0;
    _stepInterval = 0;
    _minPulseWidth = 1;
    _enablePin = 0xff;
    _lastStepTime = 0;
    _pin[0] = pin1;
    _pin[1] = pin2;
    _pin[2] = pin3;
    _pin[3] = pin4;
    _enableInverted = false;
    
    // NEW
    _n = 0;
    _c0 = 0.0;
    _cn = 0.0;
    _cmin = 1.0;
    _direction = DIRECTION_CCW;

    int i;
    for (i = 0; i < 4; i++)
	_pinInverted[i] = 0;
    if (enable)
	enableOutputs();
    // Some reasonable default
    setAcceleration(1);
    setMaxSpeed(1);
}

//ajout arpschuino///////////////////////////////////////////////////////////////////
ArpAccelStepper::ArpAccelStepper()
{
    ///////////////////////from ArpStepper//////////////////
    _inverted=false;
    _step_per_revolution=400;//step per revolution;//nombre de pas par tour
    _revolutions=10;//number of revolutions desired (in float to have decimal numbers)
                      //nombre de tours souhaite(en float pour avoir les nombres a virgule)
    //m_AccelStepper(1),//1 mean Driver mode
    _resolution=255; //the resolution of the command in bits
    ///////////////////////from AccelStepper//////////////////    
    _interface = DRIVER;//DRIVER;//interface;driver mode
    _currentPos = 0;
    _targetPos = 0;
    _speed = 0.0;
    _maxSpeed = 0.0;
    _acceleration = 0.0;
    _sqrt_twoa = 1.0;
    _stepInterval = 0;
    _minPulseWidth = 1;
    _enablePin = 0xff;
    _lastStepTime = 0;
    // _pin[0] = pin1;
    // _pin[1] = pin2;
    // _pin[2] = pin3;
    // _pin[3] = pin4;
    _enableInverted = false;
    
    // NEW
    _n = 0;
    _c0 = 0.0;
    _cn = 0.0;
    _cmin = 1.0;
    _direction = DIRECTION_CCW;

    int i;
    for (i = 0; i < 4; i++)
	_pinInverted[i] = 0;
    // if (enable)
	// enableOutputs();
    // Some reasonable default
    setAcceleration(1);
    setMaxSpeed(1);
}

/////////////////////////////////////////////////////////////////////////////////////

ArpAccelStepper::ArpAccelStepper(void (*forward)(), void (*backward)())
{
    ///////////////////////from ArpStepper//////////////////
    _inverted=false;
    _step_per_revolution=400;//step per revolution;//nombre de pas par tour
    _revolutions=10;//number of revolutions desired (in float to have decimal numbers)
                      //nombre de tours souhaite(en float pour avoir les nombres a virgule)
    //m_AccelStepper(1),//1 mean Driver mode
    _resolution=255; //the resolution of the command in bits
    ///////////////////////from AccelStepper//////////////////    
    _interface = 0;
    _currentPos = 0;
    _targetPos = 0;
    _speed = 0.0;
    _maxSpeed = 0.0;
    _acceleration = 0.0;
    _sqrt_twoa = 1.0;
    _stepInterval = 0;
    _minPulseWidth = 1;
    _enablePin = 0xff;
    _lastStepTime = 0;
    _pin[0] = 0;
    _pin[1] = 0;
    _pin[2] = 0;
    _pin[3] = 0;
    _forward = forward;
    _backward = backward;

    // NEW
    _n = 0;
    _c0 = 0.0;
    _cn = 0.0;
    _cmin = 1.0;
    _direction = DIRECTION_CCW;

    int i;
    for (i = 0; i < 4; i++)
	_pinInverted[i] = 0;
    // Some reasonable default
    setAcceleration(1);
    setMaxSpeed(1);
}

///////////////////////from ArpStepper//////////////////
/**************************************************************************/
/*!
    @brief    Attach pins and define the number of steps per revolution.
              3 parameters for the hardware config.
    @param    dir
              outputs to be connected to the terminal DIR of the driver.
    @param    pull
              outputs to be connected to the terminal PULL (or STEP) of the driver.
    @param    step_per_revolution
              Steps per revolution, including the microsteps of the driver.              
*/
/**************************************************************************/
void ArpAccelStepper::attach(byte dir,byte pull, uint16_t step_per_revolution) //to modify to keep the possibility to have 4 pins
{
    _step_per_revolution = step_per_revolution;//step per revolution;//nombre de pas par tour
    set_pins( pull, dir);//  pull, dir  
    //Serial.print(" set pin : pull : "); Serial.print(pull);Serial.print(" dir : "); Serial.println(dir);    
}

/**************************************************************************/
/*!
    @brief    Attach pins and define the number of steps per revolution.
              5 parameters for the hardware config.
    @param    pin1 digital pin number for motor pin 1.
    @param    pin2  digital pin number for motor pin 2.
    @param    pin3 digital pin number for motor pin 3.
    @param    pin4 digital pin number for motor pin 4. 
    @param    step_per_revolution
              Steps per revolution, including the halfsteps .              
*/
/**************************************************************************/
void ArpAccelStepper::attach(uint8_t pin1,uint8_t pin2 , uint8_t pin3 , uint8_t pin4 , uint16_t step_per_revolution) //to modify to keep the possibility to have 4 pins
{
    _step_per_revolution = step_per_revolution;//step per revolution;//nombre de pas par tour
    set_pins( pin1, pin2 ,pin3, pin4);//  pull, dir  
    //Serial.print(" set pin : pull : "); Serial.print(pull);Serial.print(" dir : "); Serial.println(dir);    
}

/**************************************************************************/
/*!
    @brief  Initialisation.
    @param    RPM_min
              minimum speed in revolutions / minute. Default 6.
    @param    RPM_max
              maximum speed in revolutions / minute. Default 300.
    @param    revolutions
              number of turns desired (in float to have decimal numbers). Default 10.   
    @param    resolution
              The resolution of the position command. Default 255 (8bits).
              (1 to 65535) or _7bits (127), _8bits (255), _10bits (1023), _12bits (4095), _16bits (65535)                     
*/
/**************************************************************************/
void ArpAccelStepper::init (int16_t RPM_min,int16_t RPM_max ,float revolutions,uint16_t resolution,bool action,float acceleration)//(RPM_min, RPM_max , revolution, resolution)//
{
  //convert RPM to SPS 
  _SPS_min = RPMtoSPS (RPM_min);
  _SPS_max = RPMtoSPS (RPM_max);
  acceleration = RPMtoSPS (acceleration);

  _revolutions=revolutions;
  _resolution=resolution;
  _action=action;

  _pos_factor = _revolutions *_step_per_revolution / _resolution;


    ////////////////////////////////////////////////////////////////////////
  set_action(action);
  setMinPulseWidth(7);//////ensuite on mettra le delay ailleur...
  setMaxSpeed(_SPS_max);//steps per second.
  setAcceleration(acceleration);//a rendre variable
    ////////////////////////////////////////////////////////////////////////
}

/**************************************************************************/
/*!
    @brief  invert the direction of rotation.
    @param    inverted
              true or false.                
*/
/**************************************************************************/
void ArpAccelStepper::invert_rotation(bool inverted)
{
  _inverted = inverted;
}

/**************************************************************************/
/*!
    @brief  invert the direction of rotation.
    @param    inverted
              true or false.                
*/
/**************************************************************************/
bool ArpAccelStepper::inverted()
{
  return _inverted;
}
 

/**************************************************************************/
/*!
    @brief    update order datas.
    @param    val_pos
              given position or given direction.
    @param    val_speed
              speed at which to turn.
*/
/**************************************************************************/
void ArpAccelStepper::refresh(uint16_t val_pos,uint16_t val_speed, bool action)
{
  if(val_speed==0)
  {
    stop();
  }
  else
  {
    setMaxSpeed(map(val_speed,1,255,_SPS_min,_SPS_max));
    if(action==0)//perform
    {
       static const float pos_factor =  _revolutions *_step_per_revolution / _resolution;//float is needed for an exact calculation
       int32_t destination = val_pos * pos_factor;
        //int32_t destination = map(val_pos,0,_resolution,0,_revolutions *_step_per_revolution);
        if(_inverted)
            destination=destination * -1;  //this is not a pointer ! destination multiplicated by -1
        moveTo(destination); 
    }
    else//continuous
    {
      long destination = (val_pos<128) ? -0x6FFFFFFF : 0x6FFFFFFF;//approximately 1.8 billion steps, it's not infinite but...
      move(destination);
    }     
  }
}

/**************************************************************************/
/*!
    @brief  convert RPM (revolution per minute) in SPS (step per second)
    @param    RPM
              Revolutions / minute entry.                
*/
/**************************************************************************/
float ArpAccelStepper::RPMtoSPS (float RPM)//,int16_t RPM_max ,float revolutions,uint16_t resolution,bool action,float acceleration)//(RPM_min, RPM_max , revolution, resolution)//
{
  float RPS = RPM/60; //revolution per second
  return RPS*_step_per_revolution;  //step per second     
}

/**************************************************************************/
/*!
    @brief  set the resolution of the command in bits
    @param    resolution
              Revolutions / minute entry.                
*/
/**************************************************************************/
void ArpAccelStepper::set_resolution(uint16_t resolution)
{
    _resolution=resolution;
}

boolean ArpAccelStepper::direction()
{
    return _direction;
}

///////////////////////from AccelStepper//////////////////

void ArpAccelStepper::moveTo(long absolute)
{
    if (_targetPos != absolute)
    {
	_targetPos = absolute;
	computeNewSpeed();
	// compute new n?
    }
}

void ArpAccelStepper::move(long relative)
{
    moveTo(_currentPos + relative);
}

// Implements steps according to the current step interval
// You must call this at least once per step
// returns true if a step occurred
boolean ArpAccelStepper::runSpeed()
{
    //Serial.println("inside runspeed() !");///////////////////////////debug !/////////////////
    // Dont do anything unless we actually have a step interval
    if (!_stepInterval)
    {
        return false;
    }
    unsigned long time = micros();   
    if (time - _lastStepTime >= _stepInterval)
    {
        if (_direction == DIRECTION_CW)
        {
            // Clockwise
            _currentPos += 1;
        }
        else
        {
            // Anticlockwise  
            _currentPos -= 1;
        }
        step(_currentPos);

        _lastStepTime = time; // Caution: does not account for costs in step()

        return true;
    }
    else
    {
	    return false;
    }
}

long ArpAccelStepper::distanceToGo()
{
    return _targetPos - _currentPos;
}

long ArpAccelStepper::targetPosition()
{
    return _targetPos;
}

long ArpAccelStepper::currentPosition()
{
    return _currentPos;
}

// Useful during initialisations or after initial positioning
// Sets speed to 0
void ArpAccelStepper::setCurrentPosition(long position)
{
    _targetPos = _currentPos = position;
    _n = 0;
    _stepInterval = 0;
    _speed = 0.0;
}

// Subclasses can override
unsigned long ArpAccelStepper::computeNewSpeed()
{
    long distanceTo = distanceToGo(); // +ve is clockwise from curent location

    long stepsToStop = (long)((_speed * _speed) / (2.0 * _acceleration)); // Equation 16

    if (distanceTo == 0 && stepsToStop <= 1)
    {
	// We are at the target and its time to stop
	_stepInterval = 0;
	_speed = 0.0;
	_n = 0;
	return _stepInterval;
    }

    if (distanceTo > 0)
    {
	// We are anticlockwise from the target
	// Need to go clockwise from here, maybe decelerate now
	if (_n > 0)
	{
	    // Currently accelerating, need to decel now? Or maybe going the wrong way?
	    if ((stepsToStop >= distanceTo) || _direction == DIRECTION_CCW)
		_n = -stepsToStop; // Start deceleration
	}
	else if (_n < 0)
	{
	    // Currently decelerating, need to accel again?
	    if ((stepsToStop < distanceTo) && _direction == DIRECTION_CW)
		_n = -_n; // Start accceleration
	}
    }
    else if (distanceTo < 0)
    {
	// We are clockwise from the target
	// Need to go anticlockwise from here, maybe decelerate
	if (_n > 0)
	{
	    // Currently accelerating, need to decel now? Or maybe going the wrong way?
	    if ((stepsToStop >= -distanceTo) || _direction == DIRECTION_CW)
		_n = -stepsToStop; // Start deceleration
	}
	else if (_n < 0)
	{
	    // Currently decelerating, need to accel again?
	    if ((stepsToStop < -distanceTo) && _direction == DIRECTION_CCW)
		_n = -_n; // Start accceleration
	}
    }

    // Need to accelerate or decelerate
    if (_n == 0)
    {
	// First step from stopped
	_cn = _c0;
	_direction = (distanceTo > 0) ? DIRECTION_CW : DIRECTION_CCW;
    }
    else
    {
	// Subsequent step. Works for accel (n is +_ve) and decel (n is -ve).
	_cn = _cn - ((2.0 * _cn) / ((4.0 * _n) + 1)); // Equation 13
	_cn = max(_cn, _cmin); 
    }
    _n++;
    _stepInterval = _cn;
    _speed = 1000000.0 / _cn;
    if (_direction == DIRECTION_CCW)
	_speed = -_speed;

#if 0
    Serial.println(_speed);
    Serial.println(_acceleration);
    Serial.println(_cn);
    Serial.println(_c0);
    Serial.println(_n);
    Serial.println(_stepInterval);
    Serial.println(distanceTo);
    Serial.println(stepsToStop);
    Serial.println("-----");
#endif
    return _stepInterval;
}

// Run the motor to implement speed and acceleration in order to proceed to the target position
// You must call this at least once per step, preferably in your main loop
// If the motor is in the desired position, the cost is very small
// returns true if the motor is still running to the target position.
boolean ArpAccelStepper::run()
{
    //Serial.print("inside run()");////////////debug////
    if (runSpeed())
    {
     //Serial.println("runSpeed() return true");////////////debug////   
	computeNewSpeed();
    }
    return _speed != 0.0 || distanceToGo() != 0;
}



void ArpAccelStepper::setMaxSpeed(float speed)
{
    if (speed < 0.0)
       speed = -speed;
    if (_maxSpeed != speed)
    {
	_maxSpeed = speed;
	_cmin = 1000000.0 / speed;
	// Recompute _n from current speed and adjust speed if accelerating or cruising
	if (_n > 0)
	{
	    _n = (long)((_speed * _speed) / (2.0 * _acceleration)); // Equation 16
	    computeNewSpeed();
	}
    }
}

float   ArpAccelStepper::maxSpeed()
{
    return _maxSpeed;
}

void ArpAccelStepper::setAcceleration(float acceleration)
{
    if (acceleration == 0.0)
	return;
    if (acceleration < 0.0)
      acceleration = -acceleration;
    if (_acceleration != acceleration)
    {
	// Recompute _n per Equation 17
	_n = _n * (_acceleration / acceleration);
	// New c0 per Equation 7, with correction per Equation 15
	_c0 = 0.676 * sqrt(2.0 / acceleration) * 1000000.0; // Equation 15
	_acceleration = acceleration;
	computeNewSpeed();
    }
}

float   ArpAccelStepper::acceleration()
{
    return _acceleration;
}

void ArpAccelStepper::setSpeed(float speed)
{
    if (speed == _speed)
        return;
    speed = constrain(speed, -_maxSpeed, _maxSpeed);
    if (speed == 0.0)
	_stepInterval = 0;
    else
    {
	_stepInterval = fabs(1000000.0 / speed);
	_direction = (speed > 0.0) ? DIRECTION_CW : DIRECTION_CCW;
    }
    _speed = speed;
}

float ArpAccelStepper::speed()
{
    return _speed;
}

// Subclasses can override
void ArpAccelStepper::step(long step)
{
    switch (_interface)
    {
        case FUNCTION:
            step0(step);
            break;

	case DRIVER:
	    step1(step);
	    break;
    
	case FULL2WIRE:
	    step2(step);
	    break;
    
	case FULL3WIRE:
	    step3(step);
	    break;  

	case FULL4WIRE:
	    step4(step);
	    break;  

	case HALF3WIRE:
	    step6(step);
	    break;  
		
	case HALF4WIRE:
	    step8(step);
	    break;  
    }
}

long ArpAccelStepper::stepForward()
{
    // Clockwise
    _currentPos += 1;
	step(_currentPos);
	_lastStepTime = micros();
    return _currentPos;
}

long ArpAccelStepper::stepBackward()
{
    // Counter-clockwise
    _currentPos -= 1;
	step(_currentPos);
	_lastStepTime = micros();
    return _currentPos;
}

// You might want to override this to implement eg serial output
// bit 0 of the mask corresponds to _pin[0]
// bit 1 of the mask corresponds to _pin[1]
// ....
void ArpAccelStepper::setOutputPins(uint8_t mask)
{
    uint8_t numpins = 2;
    if (_interface == FULL4WIRE || _interface == HALF4WIRE)
	numpins = 4;
    else if (_interface == FULL3WIRE || _interface == HALF3WIRE)
	numpins = 3;
    uint8_t i;
    for (i = 0; i < numpins; i++)
	digitalWrite(_pin[i], (mask & (1 << i)) ? (HIGH ^ _pinInverted[i]) : (LOW ^ _pinInverted[i]));
}

// 0 pin step function (ie for functional usage)
void ArpAccelStepper::step0(long step)
{
    (void)(step); // Unused
    if (_speed > 0)
	_forward();
    else
	_backward();
}

// 1 pin step function (ie for stepper drivers)
// This is passed the current step number (0 to 7)
// Subclasses can override
void ArpAccelStepper::step1(long step)
{
    (void)(step); // Unused

    // _pin[0] is step, _pin[1] is direction
    setOutputPins(_direction ? 0b10 : 0b00); // Set direction first else get rogue pulses
    setOutputPins(_direction ? 0b11 : 0b01); // step HIGH
    // Caution 200ns setup time 
    // Delay the minimum allowed pulse width
    delayMicroseconds(_minPulseWidth);
    setOutputPins(_direction ? 0b10 : 0b00); // step LOW
}


// 2 pin step function
// This is passed the current step number (0 to 7)
// Subclasses can override
void ArpAccelStepper::step2(long step)
{
    switch (step & 0x3)
    {
	case 0: /* 01 */
	    setOutputPins(0b10);
	    break;

	case 1: /* 11 */
	    setOutputPins(0b11);
	    break;

	case 2: /* 10 */
	    setOutputPins(0b01);
	    break;

	case 3: /* 00 */
	    setOutputPins(0b00);
	    break;
    }
}
// 3 pin step function
// This is passed the current step number (0 to 7)
// Subclasses can override
void ArpAccelStepper::step3(long step)
{
    switch (step % 3)
    {
	case 0:    // 100
	    setOutputPins(0b100);
	    break;

	case 1:    // 001
	    setOutputPins(0b001);
	    break;

	case 2:    //010
	    setOutputPins(0b010);
	    break;
	    
    }
}

// 4 pin step function for half stepper
// This is passed the current step number (0 to 7)
// Subclasses can override
void ArpAccelStepper::step4(long step)
{
    switch (step & 0x3)
    {
	case 0:    // 1010
	    setOutputPins(0b0101);
	    break;

	case 1:    // 0110
	    setOutputPins(0b0110);
	    break;

	case 2:    //0101
	    setOutputPins(0b1010);
	    break;

	case 3:    //1001
	    setOutputPins(0b1001);
	    break;
    }
}

// 3 pin half step function
// This is passed the current step number (0 to 7)
// Subclasses can override
void ArpAccelStepper::step6(long step)
{
    switch (step % 6)
    {
	case 0:    // 100
	    setOutputPins(0b100);
            break;
	    
        case 1:    // 101
	    setOutputPins(0b101);
            break;
	    
	case 2:    // 001
	    setOutputPins(0b001);
            break;
	    
        case 3:    // 011
	    setOutputPins(0b011);
            break;
	    
	case 4:    // 010
	    setOutputPins(0b010);
            break;
	    
	case 5:    // 011
	    setOutputPins(0b110);
            break;
	    
    }
}

// 4 pin half step function
// This is passed the current step number (0 to 7)
// Subclasses can override
void ArpAccelStepper::step8(long step)
{
    switch (step & 0x7)
    {
	case 0:    // 1000
	    setOutputPins(0b0001);
            break;
	    
        case 1:    // 1010
	    setOutputPins(0b0101);
            break;
	    
	case 2:    // 0010
	    setOutputPins(0b0100);
            break;
	    
        case 3:    // 0110
	    setOutputPins(0b0110);
            break;
	    
	case 4:    // 0100
	    setOutputPins(0b0010);
            break;
	    
        case 5:    //0101
	    setOutputPins(0b1010);
            break;
	    
	case 6:    // 0001
	    setOutputPins(0b1000);
            break;
	    
        case 7:    //1001
	    setOutputPins(0b1001);
            break;
    }
}
    
// Prevents power consumption on the outputs
void    ArpAccelStepper::disableOutputs()
{   
    if (! _interface) return;

    setOutputPins(0); // Handles inversion automatically
    if (_enablePin != 0xff)
    {
        pinMode(_enablePin, OUTPUT);
        digitalWrite(_enablePin, LOW ^ _enableInverted);
    }
}

void    ArpAccelStepper::enableOutputs()
{
    if (! _interface) 
	return;

    pinMode(_pin[0], OUTPUT);
    pinMode(_pin[1], OUTPUT);
    if (_interface == FULL4WIRE || _interface == HALF4WIRE)
    {
        pinMode(_pin[2], OUTPUT);
        pinMode(_pin[3], OUTPUT);
    }
    else if (_interface == FULL3WIRE || _interface == HALF3WIRE)
    {
        pinMode(_pin[2], OUTPUT);
    }

    if (_enablePin != 0xff)
    {
        pinMode(_enablePin, OUTPUT);
        digitalWrite(_enablePin, HIGH ^ _enableInverted);
    }
}

void ArpAccelStepper::setMinPulseWidth(unsigned int minWidth)
{
    _minPulseWidth = minWidth;
}

void ArpAccelStepper::setEnablePin(uint8_t enablePin)
{
    _enablePin = enablePin;

    // This happens after construction, so init pin now.
    if (_enablePin != 0xff)
    {
        pinMode(_enablePin, OUTPUT);
        digitalWrite(_enablePin, HIGH ^ _enableInverted);
    }
}

void ArpAccelStepper::setPinsInverted(bool directionInvert, bool stepInvert, bool enableInvert)
{
    _pinInverted[0] = stepInvert;
    _pinInverted[1] = directionInvert;
    _enableInverted = enableInvert;
}

void ArpAccelStepper::setPinsInverted(bool pin1Invert, bool pin2Invert, bool pin3Invert, bool pin4Invert, bool enableInvert)
{    
    _pinInverted[0] = pin1Invert;
    _pinInverted[1] = pin2Invert;
    _pinInverted[2] = pin3Invert;
    _pinInverted[3] = pin4Invert;
    _enableInverted = enableInvert;
}

// Blocks until the target position is reached and stopped
void ArpAccelStepper::runToPosition()
{
    while (run())
	YIELD; // Let system housekeeping occur
}

boolean ArpAccelStepper::runSpeedToPosition()
{
    if (_targetPos == _currentPos)
	return false;
    if (_targetPos >_currentPos)
	_direction = DIRECTION_CW;
    else
	_direction = DIRECTION_CCW;
    return runSpeed();
}

// Blocks until the new target position is reached
void ArpAccelStepper::runToNewPosition(long position)
{
    moveTo(position);
    runToPosition();
}

void ArpAccelStepper::stop()
{
    if (_speed != 0.0)
    {    
	long stepsToStop = (long)((_speed * _speed) / (2.0 * _acceleration)) + 1; // Equation 16 (+integer rounding)
	if (_speed > 0)
	    move(stepsToStop);
	else
	    move(-stepsToStop);
    }
}

bool ArpAccelStepper::isRunning()
{
    return !(_speed == 0.0 && _targetPos == _currentPos);
}

//ajout arpschuino///////////////////////////////////////////////////////////////////
/**************************************************************************/
/*!
    @brief  set the type of interface
    @param    interface
              	FUNCTION  = 0, ///< Use the functional interface, implementing your own driver functions (internal use only)
	            DRIVER    = 1, ///< Stepper Driver, 2 driver pins required
	            FULL2WIRE = 2, ///< 2 wire stepper, 2 motor pins required
	            FULL3WIRE = 3, ///< 3 wire stepper, such as HDD spindle, 3 motor pins required
                FULL4WIRE = 4, ///< 4 wire full stepper, 4 motor pins required
	            HALF3WIRE = 6, ///< 3 wire half stepper, such as HDD spindle, 3 motor pins required
	            HALF4WIRE = 8  ///< 4 wire half stepper, 4 motor pins required              
*/
/**************************************************************************/
void ArpAccelStepper::set_interface(uint8_t interface)
{
    _interface = interface;
}

/**************************************************************************/
/*!
    @brief  set the type of interface
    @param  pin1
            digital pin number for motor pin 1.
            For a ArpAccelStepper::DRIVER (interface==1), 
            this is the Step input to the driver. Low to high transition means to step)
    @param  pin2  digital pin number for motor pin 2.
            For a ArpAccelStepper::DRIVER (interface==1), 
            this is the Direction input the driver. High means forward.
    @param  pin3 digital pin number for motor pin 3.
    @param  pin4 digital pin number for motor pin 4.            
*/
/**************************************************************************/
void ArpAccelStepper::set_pins(uint8_t pin0, uint8_t pin1, uint8_t pin2, uint8_t pin3)
{
    _pin[0]= pin0;
    _pin[1]= pin1;
    _pin[2]= pin2;
    _pin[3]= pin3;
    
	enableOutputs();
}

/*!
    @brief  set the type of action, perform or continuous
    @param    action
              	perform 0       go to a specified position,
                continuous 1    turn continuously            
*/
/**************************************************************************/
void ArpAccelStepper::set_action(bool action)
{
    _action=action;
}

/////////////////////////////////////////////////////////////////////////////////////
