//var=board = "arpschuino32";
//var=board = "wilulu32";
var board = "wilulu32quad";

var A_MODE = null;
var B_MODE = null;
var stepperNum = null;
var CCNum = null;
var servoNum = null;




display_active_mode_all_port=function() 
{
	if(board == "arpschuino32")
	{
		display_active_mode('A');
		display_active_mode('B');
		document.getElementById("input_port").style.display="block";

	}
	else if(board == "wilulu32" || board == "wilulu32quad")
	{
		display_active_mode('W');
		display_active_mode('A');
		//document.getElementById("input_port").style.display="none";		
	}
}

display_active_mode=function(port) 
{
	var data = new FormData();
	data.append("PAGE", "2");
	data.append("PORT", port);
	data.append("MODE", '0');//peu importe le parametre, on indique juste qu'on veut recupérer le mode
	hide_all_blocks(port);
	var xhr = new XMLHttpRequest();
	xhr.open("POST", "get_request", true);//
	xhr.onload = function () {
		var MODE = this.responseText; 
		if(port=='A')
			A_MODE = MODE;
		else if(port=='B')
			B_MODE = MODE;
		if(MODE=='CCmotor')
			document.getElementById('val_port'+port+'mode').innerHTML = 'DC motor';//display 'DC motor'
		else			
			document.getElementById('val_port'+port+'mode').innerHTML = MODE;//display mode name
		document.getElementById(port+MODE+'_block').style.display='block';//display mode config
		document.getElementById(port+MODE).checked = true;//highlight radio button
		switch(MODE)
		{
			case "pwm":
				getBoolParam('2',port,'dmxRes','val_'+port+'_dmxRes','16 bits (2 DMX channels/output)','8 bits (1 DMX channel/output)') ;                
				getValParam('2',port,'PWM_resolution','val_'+port+'_PWM_resolution');
				getValParam('2',port,'pwmFreq','val_'+port+'_PWM_freq');
				getBoolParam('2',port,'pwmCurve','val_'+port+'_PWM_curve','straight','LED');
				break;
			case "on/off" :
				getValParam('2',port,'trigger','val_'+port+'_trigger');
				getBoolParam('2',port,'inverted','val_'+port+'_inverted','Inverted','Uninverted');
				getValParam('2',port,'trig_percent','percent'+port);
				break;
			case "servo" :
				if(servoNum!='all'){
					document.getElementById(port+"servoNumAll").checked = false;
				}
				for (var i = 0; i < 8; i++) {
					if(i!=servoNum){
						document.getElementById(port+"servoNum"+i).checked = false;
					}
				}
				break;
			case "stepper" :
				////////////////////////////////
				getValParam_radio(2,port,'stpDrivMode');//,'val_'+port+'_driv');
				if(stepperNum!='all'){
					document.getElementById(port+"stpNumAll").checked = false;
				}
				for (var i = 0; i < 4; i++) {
					if(i!=stepperNum){
						document.getElementById(port+"stpNum"+i).checked = false;
					}
				}
				break; 
			case "CCmotor" :
				if(CCNum!='all'){
					document.getElementById(port+"CCNumAll").checked = false;
				}
				for (var i = 0; i < 4; i++) {
					if(i!=CCNum){
						document.getElementById(port+"CCNum"+i).checked = false;
					}
				}							
				break;  
			case "inputs" :

				break;  				                       
			case "custom" :
				//inclure une page custom.html ???
				break; 
			default :
				//console.log('default mode');
				break;                                        
		}
	
	};
	xhr.send(data);
	return this.responseText;
}

hide_all_blocks=function(port)
{
	var x = document.getElementsByClassName(port+"mode_block");
	for (var i=0;i<x.length;i++)
	{
		x[i].style.display='none';
	}	
}

select_option=function(temp,ID)
{
	var mySelect = document.getElementById(ID);
	
	for(var i, j = 0; i = mySelect.options[j]; j++) {
	  if(i.value == temp) {
		mySelect.selectedIndex = j;
		break;
	  }
	}	
}

display_inputs_available=function(port,mode)
{
		getInput(port,"CCZero_i",'val_'+ port + '_CCZero_i','CCmotor',CCNum);
		getInput(port,"CCEnd_i",'val_'+ port + '_CCEnd_i','CCmotor',CCNum);		

		getInput(port,"stpZero_i",'val_'+ port + '_stpZero_i','stepper',stepperNum);
		getInput(port,"stpEnd_i",'val_'+ port + '_stpEnd_i','stepper',stepperNum);

	if(	B_MODE == 'inputs' || A_MODE == 'inputs')
	{
		document.getElementById(port+mode+"ZeroPBC").style.display="block";
		document.getElementById(port+mode+"ZeroPC").style.display="none";
		document.getElementById(port+mode+"EndPBC").style.display="block";
		document.getElementById(port+mode+"EndPC").style.display="none";
	}
	else 
	{
		document.getElementById(port+mode+"ZeroPBC").style.display="none";
		document.getElementById(port+mode+"ZeroPC").style.display="block";
		document.getElementById(port+mode+"EndPBC").style.display="none";
		document.getElementById(port+mode+"EndPC").style.display="block";
	}
}


getInput = function(port,headerName,val,type,number) 
{
    var data = new FormData();
    data.append("PAGE", 2);
    data.append("PORT", port);
    data.append(number+headerName, '0');
    data.append(type, number);

    var response;
    var xhr = new XMLHttpRequest();
    xhr.open("POST", "get_request", true);
    xhr.onload = function () {
        response = this.responseText;
		if(response==255)
			document.getElementById(val).innerHTML =  "?"; 
		else
        	document.getElementById(val).innerHTML =  response;
    };
    xhr.send(data);
    return  parseInt(response);
}



// function AllerA(form) {
// 	i = form.SelectMenu.selectedIndex;
// 	if (i == 0) return;
// 	console.log(i);
// 	console.log(option[i]);
// }


display_I2C_devices=function() 
{
	
	var data = new FormData();
	data.append("PAGE", "2");
	data.append("PORT", "I2C");
	data.append("nb_devices", '0');//peu importe le parametre, on indique juste qu'on veut recupérer le nombre de device

	var xhr = new XMLHttpRequest();
	xhr.open("POST", "get_request", true);//
	xhr.onload = function () {
		var NB_DEVICE = this.responseText; 

		for(let i=0;i<NB_DEVICE;i++){

			add_device();

			last_ID++;
		}
	};
	xhr.send(data);
}

function settings(port,name,min,max,type,num){

	// if(num == null && (type=='CCmotor' ||type=='stepper')){
	// 	alert("please first choose which "+type+" to config")
	// }
	//else{	
		var id= port + "_"+name;
		var val = document.getElementById(id).value;
		console.log(val);/////////////////////////////////////////
		if(val!="")
		{
			if(val<min || val>max)
				alert("the "+name+" must be set between "+min+" and "+max);
			else{
				if (arguments.length == 4) {//not device number, global setting for this port
					set_request(2,'PORT', port,name, val);
					getValParam(2,port,name,"val_"+id);
					if(name=='trigger') 
					{
						var percent=val/255*100;
						document.getElementById("percent"+port).innerHTML = percent| 0 ; 
					}
					else if(name=='PWM_resolution') 
					{
						getValParam(2,port,"pwmFreq","val_"+port+"_PWM_freq");
					}
				}
				else{
					if(num=='all')
					{
						for(var i=0;i<4;i++)
						{
							set_request(2,'PORT', port,type,i ,i+name, val);                   
						}
						getValParam(2,port,0+name,"val_"+id,type,0);
					} 
					else
					{
						set_request(2,'PORT', port,type,num ,num+name, val);
						getValParam(2,port,num+name,"val_"+id,type,num);

					}
					if(name =='thresold')
					{
						var percent=val/255*100;
						document.getElementById("CCpercent"+port).innerHTML = percent| 0 ;
						document.getElementById(port+'open_bracket_1').innerHTML = ' (';
						document.getElementById(port+'closed_bracket_1').innerHTML = '%)';  
					}				
				} 
			}
		}
	//}
}

function period_check(spr, rpm)//port, stp, 
{		//calcul la période pour un stpPerRevol et une vitesse en rpm donnée

	var RPS = rpm/60; //tours par secondes
	var round_duration = 1000/RPS;//la duree d'un tour, en milli-secondes
	var micro_round_duration = round_duration * 1000;//la duree d'un tour, en micro-secondes
	var step_duration = micro_round_duration/spr;//La duree d'un pas, en micro secondes
	
	  return step_duration; 
}

function stp_settings(port, stp)
{
	// if(stepperNum == null){
	// 	alert("please first choose which stepper to config")
	// }
	//else{
		var spr_id= port + "_stpPerRevol";
		var id_min= port + "_rpm_min";
		var id_max= port + "_rpm_max";
		var id_revol= port + "_revol";
		var id_accel= port + "_accel";

		var val_spr = document.getElementById(spr_id).value;
		var val_min = document.getElementById(id_min).value;
		var val_max = document.getElementById(id_max).value;
		var val_revol = document.getElementById(id_revol).value;
		var val_accel = document.getElementById(id_accel).value;

		if(val_spr!="")
		{
			if(val_spr<24 || val_spr>25600){
				alert("the number of step per revolution must be set between 24 and 25600 steps");
			}
			else
			{
				var rpm;var spr;
				var flag = false;
				var flagAll = false;
				if(stp=='all')
				{
					
					for(var i=0;i<4;i++)
					{
						if(val_max==""){
							rpm = getData(2,port,"stepper",i,"_rpm_max");
						}
						else{
							rpm=val_max;
						}
						
						if(period_check(val_spr, rpm)<=25){//was 50
							flagAll = true;
						}
						else{
							set_request(2,'PORT', port,'stepper',i ,i+'stpPerRevol', val_spr); 
						}                  
					}

					if(flagAll == false){
						getValParam(2,port,0+'stpPerRevol',"val_"+spr_id,'stepper',0);
					}
				}
				else
				{
					//////////////////////////////////////////
					
					if(val_max==""){
						rpm = getData(2,port,"stepper",stp,"_rpm_max");
					}
					else{
						rpm=val_max;
					}

					console.log("rpm :");
					console.log(rpm);
					console.log("periode :");
					console.log(period_check(val_spr, rpm));
					
					if(period_check(val_spr, rpm)<=25){//was 50
						flag = true;
						}
					else{
					///////////////////////////
					set_request(2,'PORT', port,'stepper',stp ,stp+'stpPerRevol', val_spr);
					getValParam(2,port,stp+'stpPerRevol',"val_"+spr_id,'stepper',stp);
					}//////////////////////////
				}
			}
		}


		if(val_min!="" || val_max!=""){
			var temp_min;
			var temp_max;
			if(val_min!=""){
				
				temp_min =  val_min;
			}
			else{
				alert("please define round/minute min");
			}
			
			if(val_max!=""){
				temp_max =  val_max;
			}
			else{
				alert("please define round/minute max");
			}

			var diff=temp_max-temp_min;

			if(diff<=0){	
				alert("RPM max must be greater than RPM min");
			}
			else
			{
				if(val_max!="")
				{
					if(val_max<1 || val_max>3000){
						alert("RPM maximum must be set between 2 and 3000");
						return;
					}
					else
					{
						if(stp=='all')
						{
							
							for(var i=0;i<4;i++)
							{
								if(val_spr==""){
									spr = getData(2,port,"stepper",stp,"stpPerRevol");
								}
								else{
									spr= val_spr;
								}
								if(period_check(spr, val_max)<=25){//was 50
									flagAll = true;
								}								
								else{
									set_request(2,'PORT', port,'stepper',i ,i+'_rpm_max', val_max);   
								}                
							}
							if(flagAll == false){
								getValParam(2,port,0+'_rpm_max',"val_"+id_max,'_rpm_max',0);
							}
						}
						else
						{   
							///////////////////////////   
							if(val_spr==""){
								spr = getData(2,port,"stepper",stp,"stpPerRevol");
							}
							else{
								spr= val_spr;
							}
		
							console.log("spr :");
							console.log(spr);
							console.log("period :");
							console.log(period_check(spr, val_max));

							if(period_check(spr, val_max)<=25){//was 50
								flag = true;
							}
							else{
							////////////////////////////////////        
							set_request(2,'PORT', port,'stepper',stp ,stp+'_rpm_max', val_max);
							getValParam(2,port,stp+'_rpm_max',"val_"+id_max,'stepper',stp);
							}                       
						} 
					}
				}
				if(val_min!="")
				{
					if(val_min<1 || val_min>900){
						alert("RPM minimum must be set between 1 and 900");
						return;
					}
					else
					{
						if(stp=='all')
						{
							for(var i=0;i<4;i++)
							{
								set_request(2,'PORT', port,'stepper',i ,i+'_rpm_min', val_min);                   
							}
							getValParam(2,port,0+'_rpm_min',"val_"+id_min,'_rpm_min',0);
						}
						else
						{  
							set_request(2,'PORT', port,'stepper',stp ,stp+'_rpm_min', val_min);
							getValParam(2,port,stp+'_rpm_min','val_'+id_min,'stepper',stp);
						}
					}
				}
			}
		}
		if(flag==true){
			alert("period too short (try with less steps per revolution and/or a lower RPM max");
		}
		if(flagAll==true){
			alert("period too short for at least one of the steppers (try with less steps per revolution and/or a lower RPM max");
		}		

		if(val_revol!="")
		{
			if(val_revol<0.1 || val_revol>10000){
				alert("the number of revolution must be set between 0.1 and 10000 rev");
			}
			else
			{
				if(stp=='all')
				{
					for(var i=0;i<4;i++)
					{
						set_request(2,'PORT', port,'stepper',i ,i+'_revol', val_revol);//with optionnal header                   
					}
					getValParam(2,port,0+'_revol','val_'+id_revol,'stepper',0);
				}
			else
				{                
					set_request(2,'PORT', port,'stepper',stp ,stp+'_revol', val_revol);//with optionnal header
					getValParam(2,port,stp+'_revol','val_'+id_revol,'stepper',stp);
				}
			}
		}

		if(val_accel!="")
		{
			if(val_accel<0.1 || val_accel>100000){
				alert("the acceleration rate must be set between 0.1 and 10000");
			}
			else
			{
				if(stp=='all')
				{
					for(var i=0;i<4;i++)
					{
						set_request(2,'PORT', port,'stepper',i ,i+'_accel', val_accel);                 
					}
					getValParam(2,port,0+'_accel','val_'+id_accel,'stepper',0);
				}
				else
				{                
					set_request(2,'PORT', port,'stepper',stp ,stp+'_accel', val_accel);
					getValParam(2,port,stp+'_accel','val_'+id_accel,'stepper',stp);
				}
			}						
		}
	//}
} 

function activeSetting(port, type, num)
{
	if(type=="stepper")
	{
	// 	if(stepperNum == null){
	// 		alert("please first choose which stepper to config")
	// 	}
	// 	else{
			const cb = document.getElementById(port+'stpActive');
			if(num=='all')
			{ 
				for(var i=0;i<4;i++)
				{
					set_request(2,'PORT', port, type,i ,i+'stpActive',cb.checked);               
				}
				getBoolParam_Switch('2',port,0+'stpActive','val_'+port+'_stpActive','Active','Inactive','stepper',0);               
			}
			else
			{
				set_request(2,'PORT', port, type, stepperNum, stepperNum+'stpActive',cb.checked);
				getBoolParam_Switch('2',port,stepperNum+'stpActive','val_'+port+'_stpActive','Active','Inactive','stepper',stepperNum);            
			}
//		}
	}
	else if(type=="CCmotor"){
		// if(CCNum == null){
		// 	alert("please first choose which motor to config")
		// }
		// else{
			const cb = document.getElementById(port+'CCActive');
			if(num=='all')
			{ 
				for(var i=0;i<4;i++)
				{
					set_request(2,'PORT', port, type,i ,i+'CCActive',cb.checked);               
				}
				getBoolParam_Switch('2',port,0+'CCActive','val_'+port+'_CCActive','Active','Inactive','CCmotor',0); 
			}
			else
			{
				set_request(2,'PORT', port, type, CCNum, CCNum+'CCActive',cb.checked);
				getBoolParam_Switch('2',port,CCNum+'CCActive','val_'+port+'_CCActive','Active','Inactive','CCmotor',CCNum);            
			}
//		}
	}
	else if(type=="stpZeroSW" || type=='stpEndSW')
	{
		if(stepperNum == null){
			alert("please first choose which motor to config")
		}

		else{
			const cb = document.getElementById(port+type);
			console.log(type);console.log(cb.checked);
			if(num=='all')
			{ 
				for(var i=0;i<4;i++)
				{
					set_request(2,'PORT', port, 'stepper',i ,i+type,cb.checked);               
				}
				getBoolParam_Switch('2',port,0+type,'val_'+port+'_'+type,'enable','disable','stepper',0);               
			}
			else
			{
				set_request(2,'PORT', port, 'stepper', stepperNum, stepperNum+type,cb.checked);
				getBoolParam_Switch('2',port,stepperNum+type,'val_'+port+'_'+type,'enable','disable','stepper',stepperNum);            
			}
		}
	}		
	else if(type=="CCZeroSW" || type=='CCEndSW')
	{
		if(CCNum == null){
			alert("please first choose which motor to config")
		}

		else{
			const cb = document.getElementById(port+type);
			console.log(type);console.log(cb.checked);
			if(num=='all')
			{ 
				for(var i=0;i<4;i++)
				{
					set_request(2,'PORT', port, "CCmotor",i ,i+type,cb.checked);               
				}
				getBoolParam_Switch('2',port,0+type,'val_'+port+'_'+type,'enable','disable','CCmotor',0);               
			}
			else
			{
				set_request(2,'PORT', port, "CCmotor", CCNum, CCNum+type,cb.checked);
				getBoolParam_Switch('2',port,CCNum+type,'val_'+port+'_'+type,'enable','disable','CCmotor',CCNum);            
			}
		}
	}
	else if(type=="servo")////optimisation possible, type servo, CC stp ensembles
	{
		const cb = document.getElementById(port+'servoActive');
		//console.log(type);console.log(cb.checked);
		if(num=='all')
		{ 
			for(var i=0;i<8;i++)/////////8888888888888888
			{
				set_request(2,'PORT', port, type,i ,i+type+"Active",cb.checked);               
			}
			getBoolParam_Switch('2',port,0+type+'Active','val_'+port+'_'+type +'Active','Active','Inactive',type,0);               
		}
		else
		{
			set_request(2,'PORT', port, type, num, num+type+"Active",cb.checked);
			//set_request(2,'PORT', port, type, i  , i  +type+"Active",cb.checked);
			getBoolParam_Switch('2',port,num+type+'Active','val_'+ port + '_' + type +'Active','Active','Inactive',type,num);
			//getBoolParam_Switch('2',port,0  +type+'Active','val_'+ port + '_' + type +'Active','Active','Inactive',type,0);            
		}
	}			
}


function radioBooleanSetting(port, type, num, val, key ,tr ,fa ,nb_devices)
{
	if(num == null){
		alert("please first choose which "+type+" to config")
	}
	else{
		if( typeof(nb_devices) == 'undefined' ){
			nb_devices=4;//default value
		}
		if(num=='all')
		{ 
			for(var i=0;i<nb_devices;i++)
			{
				set_request(2,'PORT', port,type ,i , i+key ,val) ;             
			}
			getBoolParam('2',port,0 +key,'val_'+port+'_'+key, tr, fa ,type,0);            
		}
		else
		{
			set_request(2,'PORT', port, type, num, num+key,val);
			getBoolParam('2',port,num+key,'val_'+port+'_'+key, tr, fa, type, num);         
		}
	}
}

function get_detail_val(port,num,type)
{ 
	if(type=='stp')
	{
		stepperNum=num;
	}
	else if(type=='CC')
	{
		CCNum=num;
	}
	else if(type=='servo')
	{
		servoNum=num;
	}	

	if(num=="all")
	{
		document.getElementById('pre_'+type+port+'num').innerHTML = 'all ';
		document.getElementById(type+port+'num').innerHTML = 's';
		if(type=='stp')
		{
			document.getElementById('val_'+port+'_stpPerRevol').innerHTML = ' ';
			document.getElementById('val_'+port+'_rpm_max').innerHTML = '  ';
			document.getElementById('val_'+port+'_rpm_min').innerHTML = '  ';
			document.getElementById('val_'+port+'_revol').innerHTML = '  ';
			document.getElementById('val_'+port+'_accel').innerHTML = '  ';
			document.getElementById('val_'+port+'_stpInverted').innerHTML = '  ';
			document.getElementById('val_'+port+'_stpAction').innerHTML = '  '; 
			document.getElementById('val_'+port+'_stp_dmxRes').innerHTML = '  ';

			document.getElementById(port+"stepper_Inverted").checked = false;
			document.getElementById(port+"stepper_Uninverted").checked = false; 
			document.getElementById(port+"stepper_continuous").checked = false;
			document.getElementById(port+"stepper_perform").checked = false; ///////////////
			document.getElementById(port+"stepper_16 bits").checked = false;////////////////
			document.getElementById(port+"stepper_8 bits").checked = false;

			document.getElementById(port+"stp_SW_setting").style.display='none';
			document.getElementById(port+"stpEndSW_setting").style.display='none';
		}  
		else if(type=='CC')
		{
			document.getElementById(port+'open_bracket_1').innerHTML = ' ';
			document.getElementById(port+'closed_bracket_1').innerHTML = ' ';
			document.getElementById('val_'+port+'_CCInverted').innerHTML = '  ';
			document.getElementById('val_'+port+'_thresold').innerHTML = ' ';
			document.getElementById("CCpercent"+port).innerHTML = ' ';
			document.getElementById('val_'+port+'_CC_freq').innerHTML = ' ';//////////////////////			
			document.getElementById(port+"CCmotor_Inverted").checked = false;
			document.getElementById(port+"CCmotor_Uninverted").checked = false; 			
		} 
		else if(type=='servo')
		{
			document.getElementById('val_'+port+'_angle').innerHTML = '  ';		
			document.getElementById(port+"servo_Inverted").checked = false;
			document.getElementById(port+"servo_Uninverted").checked = false; 			
		} 		       
	}
	else
	{
		document.getElementById('pre_'+type+port+'num').innerHTML = '';stepperNum
		document.getElementById(type+port+'num').innerHTML = ' '+ num ;
		document.getElementById(port+"stp_SW_setting").style.display='block';
		if(type=='stp')
		{            
			getValParam(2,port,stepperNum+'stpPerRevol','val_'+port+'_stpPerRevol','stepper',stepperNum);
			getValParam(2,port,stepperNum+'_rpm_min','val_'+port+'_rpm_min','stepper',stepperNum);
			getValParam(2,port,stepperNum+'_rpm_max','val_'+port+'_rpm_max','stepper',stepperNum);
			getValParam(2,port,stepperNum+'_revol','val_'+port+'_revol','stepper',stepperNum);
			getValParam(2,port,stepperNum+'_accel','val_'+port+'_accel','stepper',stepperNum);
			getBoolParam_Switch(2,port,stepperNum+'stpActive','val_'+port+'_stpActive','Active','Inactive','stepper',stepperNum);

			getBoolParam(2,port,stepperNum+'stpInverted','val_'+port+'_stpInverted','Inverted','Uninverted','stepper',stepperNum);
////////////////////////////////////////////////////////////////"val_A_stpAction"/////////////////////////////////////////////////////////////////////////
			getBoolParam(2,port,stepperNum+'stpAction','val_'+port+'_stpAction','continuous','perform','stepper',stepperNum);

/*///////////////////////////////////////////////////// switchs disabled on wilulu32 ///////////////////////////////////////////////////////////////////////////////////
			getBoolParam_Switch(2,port,stepperNum+'stpZeroSW','val_'+port+'_stpZeroSW','enable','disable','stepper',stepperNum);
			getBoolParam_Switch(2,port,stepperNum+'stpEndSW','val_'+port+'_stpEndSW','enable','disable','stepper',stepperNum);

			getBoolParam(2,port,stepperNum+'stp_dmxRes','val_'+port+'_stp_dmxRes','16 bits','8 bits','stepper',stepperNum);
			getValParam(2,port,stepperNum+'stpHomSpeed','val_'+port+'_stpHomSpeed','stepper',stepperNum);
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*/			
			(function() {
				var data = new FormData();
				data.append("PAGE", 2);
				data.append("PORT", port);
				data.append(stepperNum+'stpAction', '0');
				data.append('stepper', stepperNum);
				var xhr = new XMLHttpRequest();
				xhr.open("POST", "get_request", true);/////////////////////////////ccc////
				xhr.onload = function () {	
					if(this.responseText==1) {
						document.getElementById('val_'+port+'_stpAction').innerHTML = 'continuous';
						document.getElementById(port+'stepper_continuous').checked = true;
						document.getElementById(port+'_stp_dmx_setting').style.display='none';
						document.getElementById(port+'_revol_block').style.display='none';
						document.getElementById(port+'_homing_block').style.display='none';
					}
					else {
						document.getElementById('val_'+port+'_stpAction').innerHTML = 'perform';
						document.getElementById(port+'stepper_perform').checked = true;
						document.getElementById(port+'_stp_dmx_setting').style.display='block';
						document.getElementById(port+'_revol_block').style.display='block';
						//document.getElementById(port+'_homing_block').style.display='block';   //disabled on wilulu32
					}
					document.getElementById(port+'stpActive_switch').style.display='block';
					
				};

				xhr.send(data);		
			})()//fonction anonyme auto invoqué
			//display_autocal(port); disabled on wilulu32 //////////////////////////////////////////////////////////////////////
		}
		else if(type=='CC')
		{
			document.getElementById(port+'open_bracket_1').innerHTML = ' (';
			document.getElementById(port+'closed_bracket_1').innerHTML = '%)';

			getBoolParam_Switch(2,port,CCNum+'CCActive','val_'+port+'_CCActive','Active','Inactive','CCmotor',CCNum);

			getBoolParam(2,port,CCNum+'CCdvrType','val_'+port+'_CCdvrType','Dir/speed','H-bridge classic','CCmotor',CCNum);
			getBoolParam(2,port,CCNum+'CCInverted','val_'+port+'_CCInverted','Inverted','Uninverted','CCmotor',CCNum); 
			getValParam(2,port,CCNum+'thresold','val_'+ port + '_thresold','CCmotor',CCNum);
			getValParam(2,port,CCNum+'thresold_percent',"CCpercent"+port,'CCmotor',CCNum);
			getValParam(2,port,CCNum+'CC_freq','val_'+ port + '_CC_freq','CCmotor',CCNum);///////////////////////////
/*///////////////////////////////////////////////////// switchs disabled on wilulu32 /////////////////////////////////////
			getBoolParam_Switch(2,port,CCNum+'CCZeroSW','val_'+port+'_CCZeroSW','enable','disable','CCmotor',CCNum);
			getBoolParam_Switch(2,port,CCNum+'CCEndSW','val_'+port+'_CCEndSW','enable','disable','CCmotor',CCNum);
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*/
			document.getElementById(port+'CCActive_switch').style.display='block';	
		} 
		else if(type=='servo')
		{
			getBoolParam_Switch(2,port,num+type+'Active','val_'+port+'_'+type+'Active','Active','Inactive',type,num);//pour optimiser
			getValParam(2,port,num+'angle','val_'+ port + '_angle','servo',num);
			getBoolParam(2,port,num+'servoInverted','val_'+port+'_servoInverted','Inverted','Uninverted','servo',num); 
			getBoolParam(2,port,num+'detach','val_'+port+'_detach','Detach','No detach','servo',num); 


			document.getElementById(port+type+'Active_switch').style.display='block'; //pour optimiser         

		} 		
	}
	if(type=='stp')
	{
		document.getElementById(port+'_stpPerRevol').value='';        
		document.getElementById(port+'_rpm_min').value='';        
		document.getElementById(port+'_rpm_max').value='';        
		document.getElementById(port+'_revol').value='';
	
	}
	else if(type=='CC')
	{
		document.getElementById(port+'_thresold').value='';
		document.getElementById('val_'+port+'_CCInverted').value='Inverted/Uninverted';
	}
}  

function display_autocal(port) {
	var data = new FormData();
	data.append("PAGE", 2);
	data.append("PORT", port);
	data.append('stepper', stepperNum);
	data.append(stepperNum+'stpZeroSW', '0');
	
	var xhr = new XMLHttpRequest();
	xhr.open("POST", "get_request", true);
	xhr.onload = function () {	
		if(this.responseText==1) {
			document.getElementById(port+'_autocalibration').style.display='block';
		}
		else {
			document.getElementById(port+'_autocalibration').style.display='none';
		}
	};

	xhr.send(data);		
}		

function active_block(check_box,name,optional_name)//active_block(port+type+'Active',port+'_'+type+'_setting');A_servo_setting
{
	if(document.getElementById(check_box).checked == false) 
	{
		console.log('no checked');
		document.getElementById(name).style.display='none';
		if( typeof(optional_name) != 'undefined' ){
			document.getElementById(optional_name).style.display='none';
		}
	}
		
	else
	{
		console.log('checked');
		document.getElementById(name).style.display='block';
		if( typeof(optional_name) != 'undefined' ){
			document.getElementById(optional_name).style.display='block';
		}		
	}
		
}


var cal_timer;
function autocalibration(port)
{
	console.log('autocalibration');console.log(stepperNum);
	var data = new FormData();
	data.append("PAGE", 2);
	data.append("PORT", port);
	data.append('stepper', stepperNum);
	data.append("autocalibration", '0');
	var response;
	var xhr = new XMLHttpRequest();
	xhr.open("POST", "get_request", true);
	xhr.onload = function () {
		response = this.responseText;
		document.getElementById("val"+port+"_autocalibration").innerHTML =  response;
		if(response != "autocalibration complete.")
		{
			cal_timer = setInterval( timer, 1000,port);
		}
	};
	xhr.send(data);
}   
function timer(port) {

	var response;
	var xhr = new XMLHttpRequest();
	xhr.open("GET", "get_autocalibration_status", true);
	xhr.onload = function () {
		response = this.responseText;
		console.log(response);
		document.getElementById("val"+port+"_autocalibration").innerHTML =  response;

		if(response == "autocalibration complete")
		{
			clearInterval(cal_timer);
			getValParam(2,port,stepperNum+'_revol','val_'+port+'_revol','stepper',stepperNum);

		}
		
	};
	xhr.send();
}
////////////////////////I2C ///////////////////////////
var nb_devices = 0;
var last_ID = 0;

function return_nb_devices() {
	var ID = nb_devices;
	nb_devices ++;
	return ID;
}

function device_request() {
	var data = new FormData();
	data.append("PAGE", 2);
	data.append("PORT", "I2C");
	data.append("device_request", '0');
	var nb_devices;
	var xhr = new XMLHttpRequest();
	xhr.open("POST", "get_request", true);
	xhr.onload = function () {
		nb_devices = this.responseText;
		if(nb_devices>5){
			alert("6 i2C devices maxi !");
			return;
		}
		add_device();
	};
	xhr.send(data);
}

function add_device() {
  document.getElementById("demo"+nb_devices).innerHTML = 
	"<iframe src='I2C_device.html' name='targetframe' width=100% height=250 allowTransparency='true' scrolling='yes' frameborder='1' >";
	nb_devices++;
}

function scan_i2c()
{
    var xhttp = new XMLHttpRequest();
    xhttp.open("GET", "scan_i2c", true);
    var response;
    xhttp.onload = function () {
        response = this.responseText;
        if(xhttp.readyState === 4) {
            document.getElementById('val_scan').innerHTML = response;
        }
    };     
    xhttp.send();    
}

function stp_drive(port,mode)
{
	document.getElementById(port+'stpActive_switch').style.display='none';
	document.getElementById('val_'+port+'_stpActive').style.display='none';
	document.getElementById(port+'_stp_setting').style.display='none';
	document.getElementById('pre_stp'+port+'num').innerHTML = 'Select the ';
	document.getElementById('stp'+port+'num').innerHTML = ' to configure';
	
	var x = document.getElementsByName(port+"stpNum");
	for (var i=0;i<5;i++)
	{
		x[i].checked = false;
	}
	set_request(2,'PORT',port,'stpDrivMode',mode);
	//getValParam(2,port,'stpDrivMode');//,'val_'+port+'_driv');	
}

/*
function select_num(port,num,type){
	get_detail_val(port,num,type);//get_detail_val('A','2','CC')
	//active_block(port+type+'Active',port+'_'+type+'_setting');//active_block('AservoActive','A_servo_setting')


}*/

